


RZ(1)               UNIX Programmer's Manual                RZ(1)



NAME
     rx, rb, rz - XMODEM, YMODEM, ZMODEM (Batch) file receive

SYNOPSIS
     rz [- +abepqtuvy]
     rb [- +abqtuvy]
     rx [- abceqtuv] file
     gz file ...
     [-][v]rzCOMMAND

DESCRIPTION
     This program uses error correcting protocols to receive
     files over a dial-in serial port from a variety of programs
     running under PC-DOS, CP/M, Unix, and other operating sys-
     tems.  It is invoked from a shell prompt manually, or
     automatically as a result of an "sz file ..." command given
     to the calling program.


     Rz is not intended be called from cu(1), or other communica-
     tions programs.  Unix flavors of Omen Technology's
     Professional-YAM communications software are available for
     dial-out applications.  (Reg.)

     Rz (Receive ZMODEM) receives files with the ZMODEM batch
     protocol.  Pathnames are supplied by the sending program,
     and directories are made if necessary (and possible).  Nor-
     mally, the "rz" command is automatically issued by the cal-
     ling ZMODEM program, but some defective ZMODEM implementa-
     tions may require starting rz the old fashioned way.  Rz
     does not support ZMODEM Crash Recovery and certain other
     ZMODEM features.  Unix flavors of Professional-YAM may be
     linked to "rz" and used in place of this program to support
     these ZMODEM features.


     Rb receives file(s) with YMODEM, accepting either standard
     128 byte sectors or 1024 byte sectors (YAM sb -k option).
     The user should determine when the 1024 byte block length
     actually improves throughput without causing lost data or
     even system crashes.

     If True YMODEM (Omen Technology trademark) file information
     (file length, etc.) is received, the file length controls
     the number of bytes written to the output dataset, and the
     modify time and file mode (iff non zero) are set accord-
     ingly.

     If no True YMODEM file information is received, slashes in
     the pathname are changed to underscore, and any trailing
     period in the pathname is eliminated.  This conversion is
     useful for files received from CP/M systems.  With YMODEM,



Printed 7/4/90                OMEN                              1






RZ(1)               UNIX Programmer's Manual                RZ(1)



     each file name is converted to lower case unless it contains
     one or more lower case letters.


     Rx receives a single file with XMODEM or XMODEM-1k protocol.
     The user should determine when the 1024 byte block length
     actually improves throughput without causing problems.  The
     user must supply the file name to both sending and receiving
     programs.  Up to 1023 garbage characters may be added to the
     received file.

     Gz is a shell script which calls sz to command Pro-YAM or
     ZCOMM to transmit the specified files.  Pathnames used with
     gz must be escaped if they have special significance to the
     Unix shell.
     EXAMPLE: gz "-a C:*.c D:*.h"


     Rz may be invoked as rzCOMMAND (with an optional leading -
     as generated by login(1)).  For each received file, rz will
     pipe the file to ``COMMAND filename'' where filename is the
     name of the transmitted file with the file contents as stan-
     dard input.

     Each file transfer is acknowledged when COMMAND exits with 0
     status.  A non zero exit status terminates transfers.

     A typical use for this form is rzrmail which calls rmail(1)
     to post mail to the user specified by the transmitted file
     name.  For example, sending the file "caf" from a PC-DOS
     system to rzrmail on a Unix system would result in the con-
     tents of the DOS file "caf" being mailed to user "caf".

     On some Unix systems, the login directory must contain a
     link to COMMAND as login sets SHELL=rsh which disallows
     absolute pathnames.  If invoked with a leading ``v'', rz
     will report progress to /tmp/rzlog.  The following entry
     works for Unix SYS III/V:
                rzrmail::5:1::/bin:/usr/local/rzrmail
     If the SHELL environment variable includes rsh or rksh (res-
     tricted shell), rz will not accept absolute pathnames or
     references to a parent directory, will not modify an exist-
     ing file, and removes any files received in error.

     If rz is invoked with stdout and stderr to different
     datasets, Verbose is set to 2, causing frame by frame pro-
     gress reports to stderr.  This may be disabled with the q
     option.


     The meanings of the available options are:




Printed 7/4/90                OMEN                              2






RZ(1)               UNIX Programmer's Manual                RZ(1)



     a    Convert files to Unix conventions by stripping carriage
          returns and all characters beginning with the first
          Control Z (CP/M end of file).
     b    Binary (tell it like it is) file transfer override.
     c    Request 16 bit CRC.  XMODEM file transfers default to 8
          bit checksum.  YMODEM and ZMODEM normally use 16 bit
          CRC.
     D    Output file data to /dev/null; for testing.  (Unix
          only)
     e    Force sender to escape all control characters; normally
          XON, XOFF, DLE, CR-@-CR, and Ctrl-X are escaped.
     p    (ZMODEM) Protect: skip file if destination file exists.
     q    Quiet suppresses verbosity.
     t tim
          Change timeout to tim tenths of seconds.
     v    Verbose causes a list of file names to be appended to
          /tmp/rzlog .  More v's generate more output.
     y    Yes, clobber any existing files with the same name.

EXAMPLES
     (Pro-YAM command)
     <ALT-2>
     Pro-YAM Command: sz *.h *.c
     (This automatically invokes rz on the connected system.)

SEE ALSO
     ZMODEM.DOC, YMODEM.DOC, Professional-YAM, crc(omen),
     sz(omen), usq(omen), undos(omen)

     Compile time options required for various operating systems
     are described in the source file.

NOTES
     ZMODEM's support of XOFF/XON flow control allows proper
     operation in many environments that do not support XMODEM
     uploads.  Unfortunately, not all timesharing systems support
     input flow control.  The TTY input buffering on some systems
     may not adequately buffer long blocks or streaming input at
     high speed.  You should suspect this problem when you can't
     send data to the Unix system at high speeds using ZMODEM,
     but YMODEM-1k or XMODEM-1k, when YMODEM with 128 byte blocks
     works properly.

     The DSZ or Pro-YAM zmodem l numeric parameter may be set to
     a value between 64 and 1024 to limit the burst length ("zmo-
     dem pl128").  Although this compromises ZMODEM's throughput,
     ZMODEM's superior reliability remains intact.

     If a program that does not properly implement the specified
     file transfer protocol causes rz to "hang" the port after a
     failed transfer, either wait for rz to time out or keyboard
     a dozen Ctrl-X characters.  Every reported instance of this



Printed 7/4/90                OMEN                              3






RZ(1)               UNIX Programmer's Manual                RZ(1)



     problem has been corrected by using ZCOMM, Pro-YAM, DSZ, or
     other program with a correct implementation of the specified
     protocol.

     Many programs claiming to support YMODEM only support XMODEM
     with 1k blocks, and they often don't get that quite right.

     In the case of a few poorly designed microcomputers, sending
     serial data to a tty port at sustained high speeds has been
     known to cause lockups, system halts, kernel panics, and
     occasional antisocial behaviour.  This problem is not unique
     to rz; CRT terminals with block mode transmission and line
     noise have the same effect.  When experimenting with high
     speed input to a system, consider rebooting the system if
     the file transfers are not successful, especially if the
     personality of the system appears altered.

     The Unix "ulimit" parameter must be set high enough to per-
     mit large file transfers to Unix.

     32 bit CRC code courtesy Gary S. Brown.  Directory creation
     code from John Gilmore's PD TAR program.

BUGS
     Rz is not intended be called from cu(1), or other communica-
     tions programs.  Unix flavors of Omen Technology's
     Professional-YAM communications software are available for
     dial-out applications.

     Rz does not support ZMODEM Crash Recovery and many other
     ZMODEM features.  Unix flavors of Professional-YAM may be
     linked to "rz" to support these features.

     Pathnames are restricted to 127 characters.  In XMODEM sin-
     gle file mode, the pathname given on the command line is
     still processed as described above.  The ASCII option's
     CR/LF to NL translation merely deletes CR's; undos(omen)
     performs a more intelligent translation.

VMS VERSION
     The VMS version does not set the file time.

     VMS C Standard I/O and RMS may interact to modify file con-
     tents unexpectedly.

     The VMS version does not support invocation as rzCOMMAND .
     The current VMS version does not support XMODEM, XMODEM-1k,
     or YMODEM.

     According to the VMS documentation, the buffered input rou-
     tine used on the VMS version of rz introduces a delay of up
     to one second for each protocol transaction.  This delay may



Printed 7/4/90                OMEN                              4






RZ(1)               UNIX Programmer's Manual                RZ(1)



     be significant for very short files.  Removing the "#define
     BUFREAD" line from rz.c will eliminate this delay at the
     expense of increased CPU utilization.

     For high speed operation, try increasing the SYSGEN parame-
     ter TTY_TYPAHDSZ to 256.

     The VMS version causes DCL to generate a random off the wall
     error message under some error conditions; this is a result
     of the incompatibility of the VMS "exit" function with the
     Unix/MSDOS standard.

ZMODEM CAPABILITIES
     Rz supports incoming ZMODEM binary (-b), ASCII (-a), protect
     (-p), clobber (-y), and append (-+) requests.  Other options
     sent by the sender are ignored.  The default is protect (-p)
     and binary (-b).

     The Unix versions support ZMODEM command execution.

FILES
     rz.c, crctab.c, rbsb.c, zm.c, zmodem.h Unix source files.

     rz.c, crctab.c, vrzsz.c, zm.c, zmodem.h, vmodem.h,
     vvmodem.c, VMS source files.

     /tmp/rzlog stores debugging output generated with -vv option
     (rzlog on VMS).



























Printed 7/4/90                OMEN                              5



