/******************** MODULE INFO  ****************************/
/*
**  File name   :  stkfpdp11.c
*/
/*  AUTHOR      :  Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp) */
/*  VERSION     :  1.0                                        */
/*  DATE        :  Wen Oct 09 2002                   */
/*
*   Compiler    :  GNU C 3.2
*   Project     :  proc  Real-Time Kernel
*   Contents    :  Stack frame builder for Real-Time Kernel
*                  Processor dependent part: PDP/11
*   Functions   :  stack_frame
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp) October 9. 2002:
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
#include "proc.h"


/*===========  stack_frame  ================================
*
*   Purpose:      Initialize a stack frame. Insert sr, pc,
*                 pid ptr and parameters.
*
*   Stack frame:  addr from end    register
*                 -------------    ----------
*                 -(psiz+20)       pc   (int)
*   nparam*4      -(psiz+18)       ps   (int)
*     psiz        -(psiz+6)        r0-5 (int)
*                 -(psiz+4)        xxx  (int) (dummy return address)
*                 -(psiz+2)        pid  (int)
*                 -(psiz)          arg0 (int)
*                 -(psiz-2)        arg1 (int)
*                                  ...
*                 0                ---------
*
*   Input:        workspace ptr
*                 workspace size
*                 pid ptr
*                 ptr to process function
*                 ptr to number of parameters. Following the address
*                 of nparam, eventually parameters.
*   Output:       contents of workspace
*   Return:       stack ptr value
*/
struct pdp11frame {
	int regs[6];
	int ps;
	void (*pc)();
	int dummy;
	PID *pid;
	int args[0];
};

char *stack_frame(char *ws, int wssize, PID *pid,
                   void (*func)(), int *nparam)
{
  char  *sp;
  int   sr, i, parnum = *nparam++;

  ws = ws+wssize;                     /* ws end + 1                      */
  ws = (char *)((int)ws & ~1);        /* align end of workspace          */
  sp = ws - ((parnum * 2) + sizeof(struct pdp11frame)); /* stack frame start */
  ((struct pdp11frame *)sp)->pc   = func;   /* program counter          */
  ((struct pdp11frame *)sp)->ps   = 0;      /* PS = 0          */
  ((struct pdp11frame *)sp)->pid  = pid;    /* point to pid slot        */

  for (i = 0; i < parnum; i++) {
  ((struct pdp11frame *)sp)->args[i]  = *nparam++;  /* point to pid slot   */
  }
  return(sp);
}
