/******************** MODULE INFO  ****************************/
/*
**  File name   :  chan2.c
*/
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*  DATE        :  Tue Jul 27 08:56:44 1999                   */
/*
*   Compiler    :  ANSI C
*   Project     :  proc  Real-Time Kernel
*   Functions   :  Extention for chan.c - channel functions.
*                  Non-blocking i/o functions.
*   Constants   :  see chan.h
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*    Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp) Oct. 15.2002:
*        Add conditional compile statements for smaller object on GCC
*
*/
#include "proc.h"
#include "chan.h"


extern int proc_runcnt;



/*===========  chanIfOutChar  ================================
*
*   Purpose:      If the channel is not full then
*                 put a byte into the channel.
*                 If the channel was empty, return 2.
*                 If the channel was not full, return 1.
*                 If the channel was full, return 0.
*
*                 The interrupt is not enabled nor disabled during
*                 the execution. The user is suggested to disable
*                 the interrupt before use.
*
*                 The function is intended for interrupt-driven
*                 receive handles.
*
*   Input:        ptr to chan
*                 byte
*   Output:       none
*   Return:       Full: 0, Not full: 1 Empty: 2.
*
*/
#ifdef L_chanIfOutChar
int chanIfOutChar(CHAN *cp, int byte)
{
  int i;

  if (cp->left.value > 0) {
    cp->left.value--;
    if ((i = (cp->ii + 1)) >= cp->size) i = 0;
    cp->fifo[i] = (unsigned char)byte;
    cp->ii = i;
    return(procSemSignalCareful(&(cp->used)) + 1);
  }
  return(0);
}

#endif

/*===========  chanIfInChar  ===============================
*
*   Purpose:      If the channel is not empty then output a
*                 byte from the channel to the user.
*                 If the channel was empty, return 0.
*                 If the channel was not full, return 1.
*                 If the channel was full, return 2.
*
*                 The interrupt is not enabled nor disabled during
*                 the execution. The user is suggested to disable
*                 the interrupt before use.
*
*                 The function is intended for interrupt-driven
*                 transmit handles.
*
*   Input:        ptr to chan
*                 ptr to unsigned char
*   Output:       byte from the channel
*   Return:       Empty: 0, Not full: 1 Full: 2.
*
*/
#ifdef L_chanIfInChar
int chanIfInChar(CHAN *cp, unsigned char *byte)
{
  int i;

  if (cp->used.value > 0) {
    cp->used.value--;
    if ((i = (cp->oi + 1)) >= cp->size) i = 0;
    *byte = cp->fifo[i];
    cp->oi = i;
    return(procSemSignalCareful(&(cp->left)) + 1);
  }
  return(0);
}
#endif
