/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.io.JoystickMapper;
import bk2010.preferences.KeyMap;
import java.awt.event.KeyEvent;
import java.io.File;

public final class KeyMapper {
    public static final int EVT_STOP = 1;
    public static final int EVT_VIDEOMODE = 2;
    public static final int EVT_RESET = 4;
    public static final int EVT_TRACETOGGLE = 8;
    public static final int EVT_SCREENSHOT = 16;
    public static final int EVT_DEBUG = 256;
    public static final int EVT_LDISK = 512;
    public static final int EVT_RDISK = 1024;
    public static final int EVT_QUIT = 65536;
    private volatile int nextEvent = 0;
    private volatile int nextKey = -1;
    private volatile int lastKey = -1;
    private volatile boolean pressedKey = false;
    private boolean capsLocked = false;
    private JoystickMapper joyMapper = null;
    private KeyMap keyMap = new KeyMap(new File("keyboard.ini"));

    public KeyMapper(JoystickMapper joyMapper) {
        this.joyMapper = joyMapper;
    }

    public int translateKey(KeyEvent evt) {
        int key = evt.getKeyCode();
        boolean isAlpha = false;
        switch (key) {
            case 524: {
                if (evt.getKeyLocation() == 2) {
                    key = 14;
                } else if (evt.getKeyLocation() == 3) {
                    key = 15;
                }
                if (evt.isAltDown()) {
                    key |= 0x80;
                }
                return key;
            }
            case 20: {
                this.capsLocked ^= true;
                return -1;
            }
            case 27: {
                this.nextEvent |= 1;
                return -1;
            }
            case 145: {
                this.nextEvent |= 2;
                return -1;
            }
            case 115: {
                if (!evt.isControlDown()) break;
                this.nextEvent |= 0x200;
                return -1;
            }
            case 116: {
                if (!evt.isControlDown()) break;
                this.nextEvent |= 0x400;
                return -1;
            }
            case 119: {
                if (!evt.isControlDown()) break;
                this.nextEvent |= 2;
                return -1;
            }
            case 121: {
                if (!evt.isControlDown()) break;
                this.nextEvent |= 0x10000;
                return -1;
            }
            case 122: {
                this.nextEvent = evt.isControlDown() ? (this.nextEvent |= 4) : (this.nextEvent |= 0x100);
                return -1;
            }
            case 123: {
                this.nextEvent = evt.isAltDown() ? (this.nextEvent |= 8) : (this.nextEvent |= 0x10);
                return -1;
            }
            case 19: {
                this.nextEvent |= 0x10000;
                return -1;
            }
        }
        key = this.keyMap.getMappedKey(key, evt.isShiftDown());
        if (key < 0) {
            return -1;
        }
        boolean bl = isAlpha = key >= 64 && key <= 127;
        if (isAlpha) {
            if (evt.isControlDown()) {
                key &= 0x1F;
            } else if (this.capsLocked) {
                key ^= 0x20;
            }
        }
        if (evt.isAltDown()) {
            key |= 0x80;
        }
        return key;
    }

    public void keyHit(KeyEvent evt) {
        if (this.joyMapper != null && this.joyMapper.translateKey(evt, true)) {
            evt.consume();
            return;
        }
        int key = this.translateKey(evt);
        if (key >= 0 && evt.getKeyCode() != this.lastKey) {
            this.nextKey = key;
            this.lastKey = evt.getKeyCode();
            this.pressedKey = true;
        }
        evt.consume();
    }

    public void keyRelease(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key >= 0 && key == this.lastKey) {
            this.nextKey = -1;
            this.lastKey = -1;
            this.pressedKey = false;
        }
        if (this.joyMapper != null) {
            this.joyMapper.translateKey(evt, false);
        }
        evt.consume();
    }

    public int pollKey() {
        if (!this.pressedKey) {
            return -1;
        }
        this.pressedKey = false;
        return this.nextKey;
    }

    public boolean pollKeyHold() {
        return this.nextKey != -1;
    }

    public int pollEvents() {
        int tmp = this.nextEvent;
        this.nextEvent = 0;
        return tmp;
    }

    public int getJoystickState() {
        if (this.joyMapper == null) {
            return 0;
        }
        return this.joyMapper.getJoystickState();
    }
}

