/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSlave;

public final class Keyboard
implements QBusSlave {
    protected short keycode = 0;
    protected short status = (short)64;
    protected boolean keyDown = false;

    @Override
    public int getBaseAddress() {
        return 65456;
    }

    @Override
    public int getNumWords() {
        return 2;
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result) {
        if (addr == 65456) {
            result.value = this.status;
            return true;
        }
        this.status = (short)(this.status & 0xFFFFFF7F);
        result.value = (short)(this.keycode & 0x7F);
        return true;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        return this.writeWord(addr, data);
    }

    @Override
    public boolean writeWord(int addr, short data) {
        if (addr == 65456) {
            this.status = (short)(this.status & 0xFFFFFFBF | data & 0x40);
            return true;
        }
        return false;
    }

    @Override
    public boolean gotInterrupt() {
        return (this.status & 0xC0) == 128;
    }

    @Override
    public byte interruptVector() {
        this.status = (short)(this.status & 0xFFFFFF7F);
        return (byte)((this.keycode & 0x80) != 0 ? 188 : 48);
    }

    @Override
    public void reset() {
        if (!this.keyDown) {
            this.keycode = 0;
            this.status = (short)64;
        } else {
            this.status = (short)192;
        }
    }

    public void punch(byte key) {
        this.keycode = (short)(key & 0xFF);
        this.status = (short)(this.status | 0x80);
        this.keyDown = true;
    }

    public void setKeyDown(boolean isDown) {
        this.keyDown = isDown;
    }

    public boolean getKeyDown() {
        return this.keyDown;
    }
}

