/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.debugger.MemoryLocation;
import bk2010.gui.helpers.Tools;
import bk2010.hardware.cpu.Disasm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MemoryLocationRenderer
extends JComponent
implements ListCellRenderer {
    private static final int POS_ADDR = 0;
    private static final int POS_CHARS = 8;
    private static final int POS_DATA = 11;
    private static final int POS_RADIX50 = 18;
    private static final int POS_BYTE1 = 22;
    private static final int POS_BYTE2 = 26;
    private static final int POS_DISASM = 32;
    private static final int POS_ANNOT = 61;
    private static final int POS_TERMINAL = 93;
    public static final String RADIX50 = " ABCDEFGHIJKLMNOPQRSTUVWXYZ$._0123456789";
    static Dimension preferredSize;
    static Dimension minimumSize;
    static Dimension maximumSize;
    MemoryLocation curLocation;
    boolean curSelected;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.curLocation = (MemoryLocation)value;
        this.curSelected = cellHasFocus;
        return this;
    }

    @Override
    public Dimension getMaximumSize() {
        if (maximumSize == null) {
            maximumSize = new Dimension(133 * Tools.fontWidth, Tools.fontHeight + 4);
        }
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (minimumSize == null) {
            minimumSize = new Dimension(0, Tools.fontHeight + 4);
        }
        return minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (preferredSize == null) {
            preferredSize = new Dimension(93 * Tools.fontWidth, Tools.fontHeight + 4);
        }
        return preferredSize;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color saveColor = g.getColor();
        Font saveFont = g.getFont();
        g.setFont(Tools.monoFont);
        if ((this.curLocation.flags & 0x20000) != 0) {
            g.setColor(Color.GREEN);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(saveColor);
        }
        String buf = String.format("%06o:", this.curLocation.address);
        g.drawString(buf, 0 * Tools.fontWidth, 2 + Tools.fontBase);
        int tmp = this.curLocation.value;
        StringBuilder srb = new StringBuilder(2);
        srb.append((char)(tmp & 0x7F));
        srb.append((char)(tmp >> 8 & 0x7F));
        buf = srb.toString();
        g.drawString(buf, 8 * Tools.fontWidth, 2 + Tools.fontBase);
        buf = String.format("%06o", this.curLocation.value);
        g.drawString(buf, 11 * Tools.fontWidth, 2 + Tools.fontBase);
        if (tmp > 63999) {
            buf = "???";
        } else {
            srb = new StringBuilder(3);
            srb.append(RADIX50.charAt(tmp / 1600));
            srb.append(RADIX50.charAt((tmp %= 1600) / 40));
            srb.append(RADIX50.charAt(tmp %= 40));
            buf = srb.toString();
        }
        g.drawString(buf, 18 * Tools.fontWidth, 2 + Tools.fontBase);
        buf = String.format("%03o", this.curLocation.value & 0xFF);
        g.drawString(buf, 22 * Tools.fontWidth, 2 + Tools.fontBase);
        buf = String.format("%03o", this.curLocation.value >> 8 & 0xFF);
        g.drawString(buf, 26 * Tools.fontWidth, 2 + Tools.fontBase);
        if ((this.curLocation.flags & 3) != 0) {
            buf = Disasm.disasm(this.curLocation.memory, (short)this.curLocation.address, false);
            g.drawString(buf, 32 * Tools.fontWidth, 2 + Tools.fontBase);
        }
        if (this.curSelected) {
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g.setFont(saveFont);
        g.setColor(saveColor);
    }
}

