/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.debugger.MemoryLocationRenderer;
import bk2010.gui.debugger.MemoryModel;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeSource;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DisasmPanel
extends JPanel {
    JList disasmList;
    MemoryModel memoryModel;

    public DisasmPanel(MemoryModel dataModel) {
        super(new BorderLayout());
        this.memoryModel = dataModel;
        this.disasmList = new JList(dataModel);
        this.disasmList.setCellRenderer(new MemoryLocationRenderer());
        this.disasmList.setPrototypeCellValue(dataModel.getElementAt(0));
        this.disasmList.setVisibleRowCount(30);
        this.disasmList.setSelectionMode(0);
        JScrollPane disasmScroll = new JScrollPane(this.disasmList, 22, 31);
        this.add(disasmScroll);
        this.setPC(-1);
    }

    public void selectAddress(int addr) {
        addr = (addr & 0xFFFF) >> 1;
        this.disasmList.setSelectedIndex(addr);
        this.disasmList.ensureIndexIsVisible(addr);
    }

    public void setPC(int addr) {
        this.memoryModel.setPC(addr);
        this.selectAddress(addr);
    }

    public static void main(String[] args) throws IOException {
        JFrame fr = new JFrame("Disasm test");
        fr.setDefaultCloseOperation(3);
        BaseBK001x machine = new BaseBK001x();
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        fr.add(new DisasmPanel(new MemoryModel(machine)));
        fr.pack();
        fr.setVisible(true);
    }
}

