/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.helpers.Tools;
import bk2010.hardware.cpu.Disasm;
import bk2010.hardware.cpu.K1801VM1;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CPURegisterRenderer
extends JComponent
implements ListCellRenderer {
    private K1801VM1 cpu;
    public static final int PSW_WIDTH = 11;
    public static final String pswBits = "  HI  TNZVC";
    static Dimension preferredSize;
    static Dimension minimumSize;
    static Dimension maximumSize;
    int curRegister = 0;
    boolean curSelected = false;

    public CPURegisterRenderer(K1801VM1 cpu) {
        this.cpu = cpu;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.curRegister = index;
        this.curSelected = cellHasFocus;
        return this;
    }

    @Override
    public Dimension getMaximumSize() {
        if (maximumSize == null) {
            maximumSize = new Dimension(11 * Tools.fontWidth + 2, Tools.fontHeight + 4);
        }
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (minimumSize == null) {
            minimumSize = new Dimension(11 * Tools.fontWidth + 2, Tools.fontHeight + 4);
        }
        return minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (preferredSize == null) {
            preferredSize = new Dimension(11 * Tools.fontWidth + 2, Tools.fontHeight + 4);
        }
        return preferredSize;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String buf = "No register";
        Color saveColor = g.getColor();
        Font saveFont = g.getFont();
        g.setFont(Tools.monoFont);
        if (this.curRegister >= 0 && this.curRegister < 8) {
            buf = String.format("%2s = %06o", Disasm.regnames[this.curRegister], this.cpu.regs[this.curRegister] & 0xFFFF);
        } else if (this.curRegister == 8) {
            buf = String.format("PSW: %06o", this.cpu.psw & 0xFFFF);
        } else if (this.curRegister == 9) {
            StringBuilder sb = new StringBuilder(11);
            short tmp = this.cpu.psw;
            int i = 11;
            while (i > 0) {
                sb.append((tmp & 1 << i - 1) > 0 ? pswBits.charAt(11 - i) : (char)' ');
                --i;
            }
            buf = sb.toString();
        }
        g.drawString(buf, 2, 2 + Tools.fontBase);
        if (this.curSelected) {
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g.setFont(saveFont);
        g.setColor(saveColor);
    }
}

