/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.cpu;

import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.K1801VM1;

public final class Disasm {
    public static final String[] asmTpl = new String[]{"Unknown", "???", "Dummy", "HALT", "WAIT", "RTI", "BPT", "IOT", "RESET", "RTT", "START", "S(TEP)", "JMP $d", "RTS $r", "SE$c", "CL$c", "SWAB $d", "BR $b", "BNE $b", "BEQ $b", "BGE $b", "BLT $b", "BGT $b", "BLE $b", "JSR $e,$d", "CLR $d", "COM $d", "INC $d", "DEC $d", "NEG $d", "ADC $d", "SBC $d", "TST $d", "ROR $d", "ROL $d", "ASR $d", "ASL $d", "MARK $m", "SXT $d", "MOV $s,$d", "CMP $s,$d", "BIT $s,$d", "BIC $s,$d", "BIS $s,$d", "ADD $s,$d", "XOR $e,$d", "SOB $e,$o", "BPL $b", "BMI $b", "BHI $b", "BLOS $b", "BVC $b", "BVS $b", "BCC $b", "BCS $b", "EMT $t", "TRAP $t", "CLRB $d", "COMB $d", "INCB $d", "DECB $d", "NEGB $d", "ADCB $d", "SBCB $d", "TSTB $d", "RORB $d", "ROLB $d", "ASRB $d", "ASLB $d", "MTPS $d", "MFPS $d", "MOVB $s,$d", "CMPB $s,$d", "BITB $s,$d", "BICB $s,$d", "BISB $s,$d", "SUB $s,$d"};
    public static final String[] regnames = new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "SP", "PC"};

    private static void printOctal(int j, StringBuilder sb) {
        int i = 15;
        while (i >= 0) {
            sb.append((char)(((j & 0xFFFF) >> i & 7) + 48));
            i -= 3;
        }
    }

    public static final String disasm(QBusProxy mem, short addr) {
        StringBuilder sb = new StringBuilder(30);
        int immWordsNum = 0;
        short[] immWords = new short[2];
        QBusReadDTO dto = new QBusReadDTO();
        Disasm.printOctal(addr, sb);
        sb.append(": ");
        if (!mem.readWord(addr, dto)) {
            sb.append("--- Unreadable memory location ---");
            return sb.toString();
        }
        int insn = dto.value;
        Disasm.printOctal(insn, sb);
        sb.append("  ");
        int op = K1801VM1.opdec[insn & 0xFFFF];
        int i = 0;
        while (i < asmTpl[op].length()) {
            char c = asmTpl[op].charAt(i);
            if (c != '$') {
                sb.append(c);
            } else {
                c = asmTpl[op].charAt(++i);
                switch (c) {
                    case 'd': 
                    case 's': {
                        String right;
                        String left;
                        short imm;
                        int mode = (c == 's' ? insn >> 6 : insn) & 0x3F;
                        if ((mode & 8) != 0) {
                            sb.append('@');
                            mode &= 0xFFFFFFF7;
                        }
                        if (mode == 23 || mode == 55) {
                            if (mode == 23) {
                                sb.append('#');
                            }
                            immWords[immWordsNum++] = -1;
                            if (!mem.readWord((short)(addr + immWordsNum * 2), dto)) {
                                sb.append("(Immediate operand unreadable)");
                                break;
                            }
                            short s = dto.value;
                            immWords[immWordsNum - 1] = s;
                            imm = s;
                            if (mode == 55) {
                                imm = (short)(imm + (addr + immWordsNum * 2 + 2));
                            }
                            Disasm.printOctal(imm, sb);
                            break;
                        }
                        switch (mode & 0x38) {
                            case 16: {
                                left = "(";
                                right = ")+";
                                break;
                            }
                            case 32: {
                                left = "-(";
                                right = ")";
                                break;
                            }
                            case 48: {
                                left = "(";
                                right = ")";
                                immWords[immWordsNum++] = -1;
                                if (!mem.readWord((short)(addr + immWordsNum * 2), dto)) {
                                    sb.append("(Immediate operand unreadable)");
                                    break;
                                }
                                short s = dto.value;
                                immWords[immWordsNum - 1] = s;
                                imm = s;
                                Disasm.printOctal(imm, sb);
                                break;
                            }
                            default: {
                                left = "";
                                right = "";
                            }
                        }
                        sb.append(left);
                        sb.append(regnames[mode & 7]);
                        sb.append(right);
                        break;
                    }
                    case 'r': {
                        sb.append(regnames[insn & 7]);
                        break;
                    }
                    case 'c': {
                        if ((insn & 0xF) == 0) {
                            sb.replace(sb.length() - 2, sb.length(), "NOP");
                            break;
                        }
                        if ((insn & 8) != 0) {
                            sb.append('N');
                        }
                        if ((insn & 4) != 0) {
                            sb.append('Z');
                        }
                        if ((insn & 2) != 0) {
                            sb.append('V');
                        }
                        if ((insn & 1) == 0) break;
                        sb.append('C');
                        break;
                    }
                    case 'b': {
                        Disasm.printOctal(addr + 2 + (byte)insn * 2, sb);
                        break;
                    }
                    case 'o': {
                        Disasm.printOctal(addr + 2 - (insn & 0x3F) * 2, sb);
                        break;
                    }
                    case 'e': {
                        sb.append(regnames[insn >> 6 & 7]);
                        break;
                    }
                    case 'm': {
                        Disasm.printOctal(insn & 0x3F, sb);
                        break;
                    }
                    case 't': {
                        Disasm.printOctal(insn & 0xFF, sb);
                        break;
                    }
                    default: {
                        sb.append("(Unknown operand class '");
                        sb.append(c);
                        sb.append("' )");
                    }
                }
            }
            ++i;
        }
        sb.append('\n');
        i = 0;
        while (i < immWordsNum) {
            Disasm.printOctal(addr + i * 2 + 2, sb);
            sb.append(": ");
            Disasm.printOctal(immWords[i], sb);
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }
}

