/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WaveReader {
    protected RandomAccessFile wf;
    protected long len;
    protected long pos;
    protected int avg = 16384;
    protected int last;
    protected boolean en = true;

    public WaveReader(File file) throws IOException {
        this.wf = new RandomAccessFile(file, "r");
        this.len = this.wf.length();
        this.pos = 40L;
        this.wf.skipBytes((int)this.pos);
    }

    public int nextSample() {
        if (!this.en) {
            this.last = -1;
            return -1;
        }
        int val = 0;
        try {
            val = this.wf.read();
            if (val == -1) {
                this.wf.seek(40L);
                System.out.append("<rewind>");
                val = this.wf.read();
            }
            val = (val & 0xFF) << 8;
        }
        catch (IOException e) {
            this.en = false;
            this.last = -1;
            return -1;
        }
        this.last = this.avg < val ? -1 : 0;
        return this.last;
    }

    public int lastSample() {
        return this.last;
    }
}

