/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.AudioAndTapePanel;
import bk2010.gui.DiskMountPanel;
import bk2010.gui.helpers.RadioButtonPanel;
import bk2010.preferences.MachineConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;

public class LauncherHWConfigurationDialog
extends JDialog {
    private MachineConfiguration selectedConfiguration = new MachineConfiguration();

    public LauncherHWConfigurationDialog() {
        super((Frame)null, "BK2010 Launcher", true);
        this.add((Component)new AudioAndTapePanel(this.selectedConfiguration), "North");
        this.add((Component)new RadioButtonPanel(this.selectedConfiguration.machine), "West");
        Box okExitpanel = Box.createHorizontalBox();
        okExitpanel.add(Box.createHorizontalGlue());
        JButton jbStart = new JButton("Start emulator");
        jbStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = true;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        });
        okExitpanel.add(jbStart);
        JButton jbExit = new JButton("Quit");
        jbExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = false;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        });
        okExitpanel.add(jbExit);
        okExitpanel.add(Box.createHorizontalGlue());
        this.add((Component)okExitpanel, "South");
        Box rPanel = Box.createVerticalBox();
        rPanel.add(new DiskMountPanel("Drive A:", this.selectedConfiguration.diskA));
        rPanel.add(new DiskMountPanel("Drive B:", this.selectedConfiguration.diskB));
        rPanel.add(Box.createVerticalGlue());
        this.add((Component)rPanel, "Center");
        this.pack();
        jbStart.requestFocusInWindow();
        Dimension winsize = this.getSize();
        Dimension scrsize = this.getToolkit().getScreenSize();
        this.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
    }

    public static MachineConfiguration doIt() {
        LauncherHWConfigurationDialog dlg = new LauncherHWConfigurationDialog();
        dlg.setVisible(true);
        dlg.dispose();
        return dlg.selectedConfiguration;
    }

    public static void main(String[] args) {
        LauncherHWConfigurationDialog test = new LauncherHWConfigurationDialog();
        test.setVisible(true);
        System.exit(0);
    }
}

