#include <stdio.h>
#include <ctype.h>

#ifdef __STDC__
#if __STDC__
#include <stdlib.h>
#include <string.h>
#endif
#endif

#ifdef vms
#define CREMOD "w","rfm=fix","mrs=512"
#else		/* For systems that can't say Record */
#define CREMOD "w"
#endif


#define BINBUFSIZ 512              /* Size of binary code buffer */

/*
 * The following text is a left (generated code) column of WABTDRIVR
 * MACRO-32 assembly listing.
 *
 * Yes, code listed right-to-left, and will be parsed appropriately.
 */

char *newdriver[]= {
"                        06 58   E9",
"                 50   030C 8F   3C",
"                                05",
"                      0D0E 8F   BB",
"                      5B   16   9A",
"                   51   50 A9   D0",
"                   5A   04 AC   D0",
"                           05   19",
"                      51   08   DB",
"                           5B   D7",
"            52   5A   5B   09   EF",
"                      5B   38   DB",
"                      5B   5B   CE",
"                   5B   14 AC   C0",
"                         00FF   30",
"                           67   B4",
"                   0C A7   08   9B",
"                   50   A0 8F   90",
"                     04 64 A9   E9",
"                   00 50   04   E2",
"                        1E A7   95",
"                           FB   19",
"                   1C A7   50   9B",
"                      67   20   93",
"                           FB   12",
"                   50   1E A7   90",
"                           FA   19",
"                   F6 50   06   E1",
"                           56   D4",
"                   50   2A A9   9A",
"                   7E   2B A9   9A",
"                      6E   50   C4",
"            55   54   55   8E   7B",
"                   18 A7   54   9B",
"              54   54   F8 8F   78",
"                   1A A7   54   9B",
"            55   54   55   50   7B",
"              16 A7   55   01   A1",
"         50   1C A7   FF4F 8F   AB",
"              1C A7   54   50   A9",
"        56   58   000001FF 8F   C1",
"              56   56   F7 8F   78",
"                   14 A7   56   B0",
"                      50   20   90",
"                   20   10 AC   D1",
"                           03   12",
"                      50   30   90",
"                   1E A7   50   9B",
"                      30   50   91",
"                           1E   12",
"                   1E A7   08   93",
"                           FA   13",
"                 53   0100 8F   3C",
"                           4E   10",
"                      55   54   D0",
"                           49   10",
"            55   08   08   54   F0",
"                   10 A7   55   B0",
"                        ED 53   F5",
"                           67   95",
"                           FC   18",
"                1E A7   A1 8F   93",
"                           07   13",
"                 50   0054 8F   3C",
"                           26   11",
"                      20   50   91",
"                           1B   12",
"                   1E A7   08   93",
"                           FA   13",
"                 53   0100 8F   3C",
"                   54   10 A7   B0",
"                           20   10",
"              54   54   F8 8F   78",
"                           19   10",
"                        F0 53   F5",
"                        A8 56   F5",
"                      50   01   9A",
"                      0D0E 8F   BA",
"                                05",
"                           54   D4",
"                           58   D5",
"                           2C   13",
"                      54   8A   9A",
"                           07   11",
"                           58   D5",
"                           23   13",
"                      8A   54   90",
"                           58   D7",
"                           1C   13",
"                 5A   01FF 8F   B3",
"                           15   12",
"                           52   D6",
"                           5B   D5",
"                           0F   13",
"                           0E   19",
"             5A   FFFFFE00 8F   CA",
"          5A   15   09   6142   F0",
"                                05",
"                                00"
};

unsigned char newcode[BINBUFSIZ];

#define EX_SUC 0x10000001
#define EX_ERR 0x10000002

#define HEX2BIN(c) (( (c) > '9'? (c)-'A'+10 : (c) )&0xF)

char name1[]="DLDRIVER.EXE";            /* End of previous driver */
char name2[]="DQDRIVER.EXE";            /* End of IDC disk driver */
char name3[]="WADRIVER.EXE";            /* Our driver's name, length must be the same as for name2 */

char filename[256];

main()
{
 FILE *fi,*fo;
 int cc,nbytes;
 unsigned char *binp=newcode,*ucp;
 char **cpp,*cp1,c1;

 /* First convert our listing to binary */

 for(cpp=newdriver; cpp < newdriver+sizeof(newdriver)/sizeof(newdriver[0]); cpp++)
  {
   cp1 = *cpp+strlen(*cpp);
   while( cp1  > *cpp )
    {
     c1 = *--cp1;
     if (isspace(c1)) continue;
     if (!isxdigit(c1) || cp1 == *cpp || !isxdigit(*--cp1 ) )
                { printf("Syntax error in listing column %d\n",cpp-newdriver+1);
                  exit(EX_ERR); }
     if( binp == newcode+BINBUFSIZ )
                { printf("Code too large\n"); exit(EX_ERR); }
     *binp++ = HEX2BIN(c1) + (HEX2BIN(*cp1)<<4);
    }
  }

 printf("Size of generated code is %%x%x bytes\n",binp-newcode);

 if (strlen(name2) != strlen(name3))
   { printf("Length of string \"%s\" differs from one for \"%s\"\n",name2,name3);
     exit(EX_ERR); }

 printf("Enter input (original VMB) file specification : "); scanf("%255s",filename);
 if ( (fi=fopen(filename,"r")) == NULL )
   { perror("Can't open input file"); exit(EX_ERR); }
 printf("Enter output (patched VMB) file specification : "); scanf("%255s",filename);
 if ( (fo=fopen(filename,CREMOD)) == NULL )
   { perror("Can't create output file"); exit(EX_ERR); }
 for (cp1=name1;( (cc=fgetc(fi)) != EOF );)
  {
   if (fputc(cc,fo)==EOF) goto wrterr;
   if ( cc == *cp1 ) { if ( *++cp1 == '\0' ) goto found1; }
   else cp1=name1;
  }
 printf("\"%s\" string not found in image\n",name1); exit(EX_ERR);

found1:                 /* Output file contains "....DLDRIVER.EXE" */
 for(nbytes=0,cp1=name2;(cc=fgetc(fi)) != EOF;)
  {
   nbytes++;
   if ( cc == *cp1 ) { if ( *++cp1 == '\0' ) goto found2; }
   else cp1=name2;
  }
 printf("\"%s\" string not found in image\n",name2); exit(EX_ERR);

found2:                 /* Now 'nbytes' is a size of DQDRIVER+it's name */
 if ( nbytes < (binp-newcode)+1+strlen(name3) )
  { printf("Alas! Your driver won't fit in place of %s driver\n",name2);
    exit(EX_ERR); }

 for(ucp=newcode;ucp<binp;ucp++)        /* Write our driver's code */
   if (fputc(*ucp,fo) == EOF) goto wrterr;

        /* Then zero fill, then .ASCIC "our_driver_name" */

 for(cc = nbytes-(binp-newcode)-1-strlen(name3);cc;cc--)
   if (fputc(0,fo) == EOF) goto wrterr;

 if(fputc(strlen(name3),fo) == EOF) goto wrterr;

 for(cp1=name3;cp1<name3+strlen(name3);cp1++)
   if (fputc(*cp1,fo) == EOF) goto wrterr;

        /* Then copy rest of VMB */

 while( (cc=fgetc(fi)) != EOF)
   if (fputc(cc,fo) == EOF) goto wrterr;

 if (ferror(fi) || fclose(fi)) { perror("Error reading file"); exit(EX_ERR); }
 if (ferror(fo) || fclose(fo)) { perror("Error writing file"); exit(EX_ERR); }
 exit(EX_SUC);

wrterr:
 perror("Error writing output file");
 exit(EX_ERR);
}
