/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/*
 * $Log: acersio.c,v $
 * Revision 1.11  2000/10/13 12:28:12  stig
 * added TRACE support
 *
 * Revision 1.10  2000/04/11 23:33:01  stig
 * Release 1.3.3 source base
 *
 * Revision 1.6  1999/08/25 19:05:36  stig
 * Implemented major re-work of console IO subsystem, also involving changes to
 * include file organisation
 *
 * Revision 1.5  1999/07/26 07:44:54  stig
 * Numerous amendments and bugfixes in preparation for first release version
 *
 * Revision 1.4  1999/06/15 16:14:01  stig
 * Removed dependencies on EBSDK source tree.
 * local libc and bios emulator libraries still required and not part of this
 * source tree.
 *
 * Revision 1.3  1999/05/24 20:54:55  stig
 * Update for preparation of IDE incorporation
 *
 * Revision 1.2  1999/04/15 19:31:43  stig
 * Added firmware functionality, implemented error log stream.
 *
 * Revision 1.1  1999/04/07 22:35:21  stig
 * After first review for manufacturing process
 *
 * Revision 1.1.1.1  1998/12/29 21:36:12  paradis
 * Initial CVS checkin
 *
 * Revision 1.1  1998/07/13  14:36:00  bissen
 * Initial revision
 *
 *
 * Original author: Dick Bissen
 * date: 7-july-98
 *
 */

#undef TRACE_ENABLE

#include "lib.h"
#include "northbridge.h"		/* for IO space accesses */

/*
 *  configuration on/off keys
 */
#define CONFIG_ON_KEY1  0x51
#define CONFIG_ON_KEY2  0x23
#define CONFIG_OFF_KEY 0xBB

/*
 * define devices in "configuration" space
 */
#define FDC   0
#define PARP  3
#define SER1  4
#define SER2  5
#define RTCL  6
#define KYBD  7
#define AUXIO 8
#define SER3  11

/*
 * chip level register offsets
 */
#define CONFIG_CONTROL        0x00
#define INDEX_ADDRESS         0x03
#define LOGICAL_DEVICE_NUMBER 0x07
#define DEVICE_ID             0x20
#define DEVICE_REV            0x21
#define POWER_CONTROL         0x22
#define POWER_MGMT            0x23
#define OSC                   0x24
#define ACTIVATE              0x30
#define ADDR_HI               0x60
#define ADDR_LOW              0x61
#define INTERRUPT_SEL         0x70

#define FDD_MODE_REGISTER     0xf0
#define FDD_OPTION_REGISTER   0xf1

#define DEVICE_ON             0x01
#define DEVICE_OFF            0x00
/*
 * values that we read back that we expect...
 */
#define VALID_DEVICE_ID       0x43

/*
 *  default device addresses
 */
#define COM1_BASE           0x3f8
#define COM1_INTERRUPT      4
#define COM2_BASE           0x2f8
#define COM2_INTERRUPT      3
#define PARP_BASE           0x378
#define PARP_INTERRUPT      7
#define FDC_BASE            0x3F0


static ui AcerSIOBase;

static ui 
AcerSIOConfigState(ui baseAddr)
{
  int devId;
  ul configPort;
  ul indexPort;
  ul dataPort;

  configPort = indexPort = baseAddr;
  dataPort = (ul) ((char *) configPort + 1);

  outportb( configPort, CONFIG_ON_KEY1 );
  outportb( configPort, CONFIG_ON_KEY2 );
  outportb( indexPort,  DEVICE_ID );
  devId = inportb( dataPort );
  if (devId != VALID_DEVICE_ID){
    baseAddr = 0;
  }
  return (baseAddr);
}

static ui 
AcerSIOdetectUltraIO()
{
  ui baseAddr;

  baseAddr = 0x3f0;
  if ((baseAddr = AcerSIOConfigState(baseAddr)) == 0x3f0){
    return baseAddr;
  }
  baseAddr = 0x370;
  if ((baseAddr = AcerSIOConfigState(baseAddr)) == 0x370){
    return baseAddr;
  }
  return (ui) 0;
}

static void 
AcerSIOrunState(ui baseAddr)
{
  outportb( baseAddr, CONFIG_OFF_KEY );
}

/*
 *
 */
static void
AcerSIOEnableCOM1(ui baseAddr)
{
  ul indexPort;
  ul dataPort;

  indexPort = baseAddr;
  dataPort = (ul) ((char *) (ul)baseAddr + 1);

  outportb( indexPort, LOGICAL_DEVICE_NUMBER );
  outportb( dataPort,  SER1);	/* select com1 */

  outportb( indexPort, ADDR_LOW );
  outportb( dataPort,  (COM1_BASE & 0xff) );

  outportb( indexPort, ADDR_HI );
  outportb( dataPort,  ((COM1_BASE >> 8) & 0xff));

  outportb( indexPort, INTERRUPT_SEL );
  outportb( dataPort,  (COM1_INTERRUPT) );

  outportb( indexPort, ACTIVATE );
  outportb( dataPort,  DEVICE_ON );
}

static void
AcerSIOEnableCOM2(ui baseAddr)
{
  ul indexPort;
  ul dataPort;

  indexPort = baseAddr;
  dataPort = (ul) ((char *) (ul)baseAddr + 1);

  outportb( indexPort, LOGICAL_DEVICE_NUMBER );
  outportb( dataPort,  SER2);	/* select com2 */

  outportb( indexPort, ADDR_LOW );
  outportb( dataPort,  (COM2_BASE & 0xff) );

  outportb( indexPort, ADDR_HI );
  outportb( dataPort,  ((COM2_BASE >> 8) & 0xff));

  outportb( indexPort, INTERRUPT_SEL );
  outportb( dataPort,  (COM2_INTERRUPT) );

  outportb( indexPort, ACTIVATE );
  outportb( dataPort,  DEVICE_ON );
}


void AcerSIOEnablePARP (ui baseAddr)
{
    ul indexPort;
    ul dataPort;

    indexPort = baseAddr;
    dataPort = (ul)((char *) (ul)baseAddr + 1);

    outportb( indexPort, LOGICAL_DEVICE_NUMBER);
    outportb( dataPort, PARP);	/* Select parallel port */

    outportb( indexPort, ADDR_LOW);
    outportb( dataPort, (PARP_BASE & 0xFF));

    outportb( indexPort, ADDR_HI);
    outportb( dataPort, ((PARP_BASE >> 8) & 0xFF));

    outportb( indexPort, INTERRUPT_SEL);
    outportb( dataPort, PARP_INTERRUPT);

    outportb( indexPort, ACTIVATE);
    outportb( dataPort, DEVICE_ON);
}

static void
AcerSIOEnableRTC(ui baseAddr)
{
  ul indexPort;
  ul dataPort;

  indexPort = baseAddr;
  dataPort = (ul) ((char *) (ul)baseAddr + 1);

  outportb( indexPort, LOGICAL_DEVICE_NUMBER );
  outportb( dataPort, RTCL );	/* select real time clock */

  outportb( indexPort, ACTIVATE );
  outportb( dataPort,  DEVICE_ON );
}

static void
AcerSIOEnableKeyboard(ui baseAddr)
{
  ul indexPort;
  ul dataPort;

  unsigned char cfgbyte;

  indexPort = baseAddr;
  dataPort = (ul) ((char *) (ul)baseAddr + 1);

  outportb( indexPort, LOGICAL_DEVICE_NUMBER );
  outportb( dataPort, KYBD );	/* select keyboard/mouse */

  outportb( indexPort, 0x70 );	// primary interrupt (keyboard) 
  outportb( dataPort,  0x01 );

  outportb( indexPort, 0x72 );	// secondary interrupt (mouse)
  outportb( dataPort,  0x0c );

  outportb( indexPort, 0xF0 );	// STIG - Ensure PS/2 keyboard type
  outportb( dataPort,  0x00 );

  outportb( indexPort, ACTIVATE );
  outportb( dataPort,  DEVICE_ON );


  /* STIG - double check the mouse and keyboard are of the right variety */
  cfgbyte = pcicfgrb( 0, 7, 0, 0x41 );
  pcicfgwb( 0, 7, 0, 0x41, cfgbyte | 0xC0 );
}

static void
AcerSIOEnableFDC(ui baseAddr)
{
  ul indexPort;
  ul dataPort;

  ui oldValue;

  indexPort = baseAddr;
  dataPort = (ul) ((char *) (ul)baseAddr + 1);

  outportb( indexPort, LOGICAL_DEVICE_NUMBER );
  outportb( dataPort, FDC );	/* select floppy controller */

  outportb( indexPort, FDD_MODE_REGISTER );
  oldValue = inportb( dataPort );

  oldValue |= 0x0E;		/* enable burst mode */
  outportb( dataPort, oldValue );

  outportb( indexPort, 0x70 );	/* set up primary interrupt select */
  outportb( dataPort,  0x06 );	/*    to 6 */

  outportb( indexPort, 0x74 );	/* set up dma channel select       */
  outportb( dataPort,  0x02 );	/*    to 2 */

  outportb( indexPort, ACTIVATE );
  outportb( dataPort,  DEVICE_ON );
}



#undef DEBUG_AcerSIO
#ifdef DEBUG_AcerSIO
void
AcerSIOReportDeviceStatus(ui baseAddr)
{
  ui indexPort;
  ui dataPort;
  ui currentControl;
  ui fer;

  indexPort = baseAddr;
  dataPort = (ui) ((char *) baseAddr + 1);

  outportb( indexPort, POWER_CONTROL );
  currentControl = inportb( dataPort );

  if (currentControl & (1 << FDC)){
    printf_dbm("\t+FDC enabled\n");
  } else {
    printf_dbm("\t-FDC disabled\n");
  }

  if (currentControl & (1 << PARP)){
    printf_dbm("\t+Parallel port enabled\n");
  } else {
    printf_dbm("\t-Parallel port disabled\n");
  }

  if (currentControl & (1 << SER1)){
    printf_dbm("\t+SER1 enabled\n");
  } else {
    printf_dbm("\t-SER1 disabled\n");
  }

  if (currentControl & (1 << SER2)){
    printf_dbm("\t+SER2 enabled\n");
  } else {
    printf_dbm("\t-SER2 disabled\n");
  }

  outportb( 0x398, 0 );
  fer = inportb( 0x399 ) & 0xff;
  printf_dbm("onboard super i/o: %x\n", fer);
  printf_dbm("\n");
}

/*
 * disable onboard super I/O functions and RTC, KBD, Mouse
 */
void disable_onboard()
{
  outportb( 0x3f2, 0 );		/* disable old floppy from driving int6,drq  */

  outportb( 0x398, 0 );		/* FER index */
  outportb( 0x399, 0x00 );	/* FER data - disable all functions */
  outportb( 0x399, 0x00 );	/* (need to write twice) */

  pcicfgwb( 0, 19, 0x4d, 0x40 );	/* disable keyboard and RTC access thru sio */
#ifdef OFFBOARD_RTC
  pcicfgwb( 0, 19, 0x4e, 0xc0 );	/* disable keyboard and RTC access thru sio */
#else
  pcicfgwb( 0, 19, 0x4e, 0xc1 );	/* disable keyboard access thru sio */
#endif
  pcicfgwb( 0, 19, 0x4f, 0xff );	/* (was 7f) disable all but port 92 */
}


void enable_offboard()
{

  outportb( 0x3f2, 0x08 );	/* DMA enable/reset for offboard floppy */
  outportb( 0x3f2, 0x0c );	/* clear reset                          */

}
void 
AcerSIOInit(void)
{
    TRACE("Running...\n" );

    AcerSIOBase = AcerSIOdetectUltraIO();

    TRACE( "Found AcerSIO at 0x%X\n", AcerSIOBase );

    if (AcerSIOBase != 0) {    /* AcerSIO Super I/O chip was detected. */
        printf_dbm("AcerSIO board detected @ base %x\n", AcerSIOBase);
        AcerSIOReportDeviceStatus(AcerSIOBase);

        AcerSIOEnablePARP(AcerSIOBase);
        AcerSIOEnableCOM1(AcerSIOBase);
        AcerSIOEnableCOM2(AcerSIOBase);

        AcerSIOEnableRTC(AcerSIOBase);
        AcerSIOEnableKeyboard(AcerSIOBase);
        AcerSIOEnableFDC(AcerSIOBase);

        AcerSIOReportDeviceStatus(AcerSIOBase);
        mobo_logf( LOG_INFO "about to disable onboard superIO, etc...\n");
        disable_onboard();
        AcerSIOrunState(AcerSIOBase);
        enable_offboard();

    } 
    else {
        mobo_logf( LOG_WARN "No AcerSIO board detected.\n");
    }

}
#else
void 
AcerSIOInit(void)
{

    AcerSIOBase = AcerSIOdetectUltraIO();
    if (AcerSIOBase != 0) {    /* AcerSIO Super I/O chip was detected. */
        AcerSIOEnableRTC(AcerSIOBase);
        AcerSIOEnableFDC(AcerSIOBase);
        AcerSIOEnablePARP(AcerSIOBase);
        AcerSIOEnableCOM1(AcerSIOBase);
        AcerSIOEnableCOM2(AcerSIOBase);
        AcerSIOEnableKeyboard(AcerSIOBase);
        AcerSIOrunState(AcerSIOBase);
    }
}
#endif

