/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

#include "osf.h"
#include "cserve.h"
#include "ledcodes.h"
#include "impure.h"
#include "memory.h"


/* This code is entered from the PALcode initialisation routine. 
 *
 * At entry:
 * 
 * t0 contains the halt code
 * 
 * It needs to then:
 *
 * 0) check if I am primary or secondary CPU
 * 1) set up the stack accordingly (nb only implementation for 2CPUs atm)
 * 
 * note: if we're re-entering the diagnostics, eg if there was a software
 * error, there will be a problem because both CPUs will think they are
 * secondary and set up their stacks at the same place.  This is no good!
 *
 */
        .text
        .set    noat
        .set    noreorder

        .globl  __start
        .ent    __start, 0
__start:
        /*--------------------------------------------------------------------*/
	/* save away the halt code (supplied in t0) */
	
	bis	t0, zero, s0

        /*--------------------------------------------------------------------*/
        /* setup of global offset table pointer */

        br      t1, 2f                  # get the current PC
2:      ldgp    gp, 0(t1)               # init gp


        /*--------------------------------------------------------------------*/
        /* Write to the LEDs */

	lda	a0, LED_INIT0(zero)
	bsr	ra, outled


        /*--------------------------------------------------------------------*/
	/* load the impure region pointer */

        lda	a2, CSERVE_K_RD_IMPURE
        call_pal PAL_CSERVE_ENTRY
	bis	v0, zero, s1

	
        /*--------------------------------------------------------------------*/
	/* Am I primary or secondary CPU? */
	/* The variable Secondary is set by the first CPU to mark its passing */

	ldbu	s2, Secondary(gp)

        /*--------------------------------------------------------------------*/
	/* setup the stack, depending on whether we're primary or secondary */

	lda	t0, STACK_MEGS(zero)
	sll	t0, 20, t0		/* produce top of stack */

	sll	s2, 17, t1		/* 1<<17 = 128K less for secondary */
	subq	t0, t1, sp		/* set the stack ptr as per CPU */

        lda     t1, -1(zero)            /* 0xFFFFFFFFFFFFFFFF */
        sll     t1, 47, t1              /* 0xFFFF800000000000 */
	bis	sp, t1, sp		/* set superpage bits in SP */


        /*--------------------------------------------------------------------*/
	/* call main() */

	/* restore args */
	bis	s0, zero, a0		/* halt code */
	bis	s1, zero, a1		/* impure region pointer */
	bis	s2, zero, a2		/* is_secondary flag */

	lda	pv, fsb_main
	jsr	ra, (pv)

	/* [we should never return here] */

	.end	__start


#if 0
        /*--------------------------------------------------------------------*/
	/* cServe hooks up with PALcode console services */

        .globl  cServe
        .ent    cServe, 0
cServe:
        call_pal PAL_CSERVE_ENTRY
        ret     zero, (ra)

        .end    cServe

#endif


        /*--------------------------------------------------------------------*/
        /* Write to the LEDs, using EV6 Superpage mode */
        /* [Assumes VA_48 is set] */

	.globl	outled
	.ent	outled
outled:
        ldah    t0, 0x8(zero)           /* 0x0000000000080000 */
        lda     t0, 0x01fc(t0)          /* 0x00000000000801FC */
        sll     t0, 24, t0              /* 0x00000801FC000000 */
        lda     t1, -1(zero)            /* 0xFFFFFFFFFFFFFFFF */
        sll     t1, 47, t1              /* 0xFFFF800000000000 */
        bis     t0, t1, t0              /* 0xFFFF8801FC000000 */
	lda	t0, 0x7000(t0)		/* 0xFFFF8801FC007000 = superpage LED*/

	stq	a0, 0(t0)		/* write argument value */
	mb
	ret	zero, (ra)
	
	.end	outled


