/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include <stdarg.h>
#include "lib.h"
#include "uilib.h"
#include "smp.h"
#include "ctype.h"
#include "ftype.h"


#define fabs(x) (( (x)<0.0) ? (-x) : x)
#define PUTNUMBER_SL_	((PRINTF_sl_)[0])

static int LeadingSign;
static int UpperCase;
static void (*PutFunction) (char);
static smp_mutex print_lock = M_FREE;

/* Prototypes for static functions */
static int PutString(char *s);
static int PutRepChar(char c, int count);
static void PutStringReverse(char *s, int index);
static int PutNumber(sl value, int radix, int width, char fill, char modifier);

#ifndef __NO_FLOATING_POINT
static int putFloat(double value, int fieldwidth, int precision, char fill, char FormatType);
static int putFloatE(double value, int fieldwidth, int precision, char fill, char ExponentChar);
static int putFloatF(double value, int fieldwidth, int precision, char fill);
static int putFloatG(double value, int fieldwidth, int precision, char fill, char ExponentChar);
#endif				/* __NO_FLOATING_POINT */

static const char *FormatItem(const char *f, va_list * ap, int *count);
static int OutputFunction(const char *f, va_list ap);
static void CopyChar(char c);
static int ExtractExponent(double *value);

typedef union {
    struct {
	char *strptr;
    } Copy;
    struct {
	FILE *File;
    } File;
} FUNCTIONDATA;

static FUNCTIONDATA FunctionData;

/* The string s is terminated by a '\0' */
static int PutString(char *s)
{
    int count = 0;
    while (*s) {
	(*PutFunction) (*s++);
	++count;
    }
    return count;
}

/* print c count times */
static int PutRepChar(char c, int count)
{
    int i = count;
    while (i--)
	(*PutFunction) (c);
    return count;
}

/* put string reverse */
static void PutStringReverse(char *s, int index)
{
    while ((index--) > 0)
	(*PutFunction) (s[index]);
}

/* prints value in radix, in a field width width, with fill
   character fill
   if radix is negative, print as signed quantity
   if width is negative, left justify
   if width is 0, use whatever is needed
   if fill is 0, use ' '
 */
static int PutNumber(sl value, int radix, int width, char fill, char modifier)
{
    int count = 0;
    char buffer[40];
    ui bufferindex = 0;
    ul uvalue;
    uw digit;
    uw left = FALSE;
    uw negative = FALSE;

    if (fill == 0)
	fill = ' ';

    switch (modifier) {
#ifndef LINT
	/*
	   ** lint warns about the tuncations that results
	   ** from these (casts) but that is precisely what
	   ** was intended.
	   * */
    case 'h':
	value = (unsigned short int) value;
	break;
    case 'l':
	if (radix < 0)
	    value = (long) value;
	else
	    value = (unsigned long) value;
	break;
    case 'L':			/* L is sl in NT and int on UNIX */
#ifdef PRINTF_L_LARGE
	break;
#endif
    default:
	if (radix < 0)
	    value = (int) value;
	else
	    value = (unsigned int) value;
#else
    default:
	;			/* Just a dummy statement to close the switch */
#endif				/* LINT */
    }

    if (width < 0) {
	width = -width;
	left = TRUE;
    }
    if (width < 0 || width > 80)
	width = 0;

    if (radix < 0) {
	radix = -radix;
	if (value < 0) {
	    negative = TRUE;
	    value = -value;
	}
    }
    switch (radix) {
    case 8:
    case 10:
    case 16:
	break;
    default:{
	    count += PutString("****");
	    return count;
	}
    }
    uvalue = value;
    do {
	if (radix != 16) {
	    digit = (uw) (uvalue % radix);
	    uvalue /= radix;
	} else {
	    digit = (uw) (uvalue & 0xf);
	    uvalue = uvalue >> 4;
	}
	buffer[bufferindex] =
	    digit + ((digit <= 9) ? '0' : ((UpperCase ? 'A' : 'a') - 10));
	bufferindex += 1;
    } while (uvalue != 0);
    /* fill # ' ' and negative cannot happen at once */
    if (negative || LeadingSign) {
	buffer[bufferindex] = negative ? '-' : '+';
	bufferindex += 1;
    }
    if ((ui) width <= bufferindex)
	PutStringReverse(buffer, bufferindex);
    else {
	width -= bufferindex;
	if (!left) {
	    count += PutRepChar(fill, width);
	}
	PutStringReverse(buffer, bufferindex);
	if (left) {
	    count += PutRepChar(fill, width);
	}
    }
    count += bufferindex;
    return count;
}

static ul ten_table_hex[25] =
{0x3ff0000000000000, 0x4024000000000000, 0x4059000000000000, 0x408f400000000000,
 0x40c3880000000000, 0x40f86a0000000000, 0x412e848000000000, 0x416312d000000000,
 0x4197d78400000000, 0x41cdcd6500000000, 0x4202a05f20000000, 0x42374876e8000000,
 0x426d1a94a2000000, 0x42a2309ce5400000, 0x42d6bcc41e900000, 0x430c6bf526340000,
 0x4341c37937e08000, 0x4376345785d8a000, 0x43abc16d674ec800, 0x43e158e460913d00,
 0x4415af1d78b58c40, 0x444b1ae4d6e2ef50, 0x4480f0cf064dd592, 0x44b52d02c7e14af6,
 0x44ea784379d99db4};

double *ten_table = (double *) &(ten_table_hex[0]);

#ifndef __NO_FLOATING_POINT
static int putFloat(double value, int fieldwidth, int precision, char fill, char FormatType)
{
    char ExponentChar = 'E';

    /* check for flag values and display special strings for them */

    switch (ftype(value)) {
    case FP_SNAN:
	return (PutString("*** sNAN ***"));
    case FP_QNAN:
	return (PutString("*** qNAN ***"));
    case FP_POS_INF:
	return (PutString("*** +INF ***"));
    case FP_NEG_INF:
	return (PutString("*** -INF ***"));
    case FP_POS_DENORM:
	return (PutString("* +denorm **"));
    case FP_NEG_DENORM:
	return (PutString("* -denorm **"));
    case FP_POS_ZERO:
	return (PutString("*** +0.0 ***"));
    case FP_NEG_ZERO:
	return (PutString("*** -0.0 ***"));

    case FP_POS_NORM:		/* Positive normalized */
    case FP_NEG_NORM:		/* Negative normalized */
	break;
    }

    switch (FormatType) {
    case 'e':
	ExponentChar = 'e';
    case 'E':
	return (putFloatE(value, fieldwidth, precision, fill, ExponentChar));
    case 'f':
	return (putFloatF(value, fieldwidth, precision, fill));
    case 'g':
	ExponentChar = 'e';
    case 'G':
	return (putFloatG(value, fieldwidth, precision, fill, ExponentChar));
    }

    return (0);
}


static int putFloatE(double value, int fieldwidth, int precision, char fill, char ExponentChar)
{
    int sign;
    int exp, exp_sign;
    int count = 0;

    if (value < 0)
	sign = 1, value = -value;
    else
	sign = 0;

    exp = ExtractExponent(&value);
    if (exp < 0)
	exp = -exp, exp_sign = 1;
    else
	exp_sign = 0;

    if (fieldwidth > 0) {	/* right justified */
	fieldwidth -= (precision + sign + 6 + (precision > 0 ? 1 : 0));
	while (fieldwidth > 0)
	    fieldwidth--, (*PutFunction) (fill), count++;
	fieldwidth = 0;
    }
    if (sign)
	(*PutFunction) ('-'), count++;	/* Output the sign */
    if (precision == 0)
	value += 0.5;		/* round the msd if there are no others */
    (*PutFunction) ((char) (((ul) value) + '0')), count++;	/* Output the MSD */

    if (precision > 0) {
	double Tmp;

	(*PutFunction) ('.' & 0x7f), count++;	/* Output the decimal place. */

	Tmp = value - (sl) value;	/* remove the integer part */
	Tmp *= ten_table[precision];	/* shift the fraction into an integer */
	Tmp += 0.5;		/* round the remaining fraction */
	count += PutNumber((sl) Tmp, 10, precision, '0', PUTNUMBER_SL_);	/* print the digits */
    }
    (*PutFunction) (ExponentChar);
    count++;			/* Output the exponent char */
    (*PutFunction) ((exp_sign) ? '-' : '+');
    count++;			/* Output the exponent sign */
    count += PutNumber((sl) exp, 10, 3, '0', PUTNUMBER_SL_);	/* generate the exp. digits */

    /* for left justified data finish the width padding if necessary */
    if (fieldwidth < 0) {
	fieldwidth = -fieldwidth - count;
	while (fieldwidth > 0)
	    fieldwidth--, (*PutFunction) (fill), count++;
    }
    return count;
}


static int putFloatF(double value, int fieldwidth, int precision, char fill)
{
    int count = 0;

    if (precision == 0)
	value += value < 0 ? (-0.5) : 0.5;	/* round the int part if there is no frac */

    count += PutNumber((sl) value, -10,
		       fieldwidth > 0 ?
		(fieldwidth - (precision > 0 ? (precision + 1) : 0)) : 0,
		       fill, PUTNUMBER_SL_);

    if (precision > 0) {
	double Tmp;

	(*PutFunction) ('.' & 0x7f), count++;	/* Output the decimal place. */

	Tmp = value < 0 ? (-value) : value;	/* remove the sign */
	Tmp = Tmp - (sl) Tmp;	/* remove the integer part */
	Tmp *= ten_table[precision];	/* shift the fraction into an integer */
	Tmp += 0.5;		/* round the remaining fraction */
	count += PutNumber((sl) Tmp, 10, precision, '0', PUTNUMBER_SL_);	/* print the digits */
    }
    /* for left justified data finish the width padding if necessary */
    if (fieldwidth < 0) {
	fieldwidth = -fieldwidth - count;
	while (fieldwidth > 0)
	    fieldwidth--, (*PutFunction) (fill), count++;
    }
    return count;
}


static int putFloatG(double value, int fieldwidth, int precision, char fill, char ExponentChar)
{
    int sign;
    int exp;
    double MagValue;
    int RequiredPrecision;

    if (value < 0)
	sign = 1, MagValue = -value;
    else
	sign = 0, MagValue = value;

    exp = ExtractExponent(&MagValue);

    /* determine the required precision for display! */
    {
	sl Tmp = (sl) (MagValue * ten_table[precision - 1] + 0.5);
	for (RequiredPrecision = precision;
	     RequiredPrecision > 1 && (Tmp % 10) == 0;
	     RequiredPrecision--, Tmp /= 10);
    }

    /* Dynamically decide wether f or e format is smaller for this value */
    /* expression macros to make this more readable */
#define FIXEDSIZE( PREC, EXP )	( (PREC) +				     \
				  ((EXP) < ((PREC)-1) ? 1		:0) +\
				  ((EXP) >=(PREC)     ? ((EXP)-(PREC)+1):0) +\
				  ((EXP) < 0	      ? (-(EXP))	:0) )
#define EXPSIZE( PREC )		( 6+(PREC) )

    if (exp < precision &&
	FIXEDSIZE(RequiredPrecision, exp) < EXPSIZE(RequiredPrecision)) {
	RequiredPrecision -= (exp + 1);
	if (RequiredPrecision < 0)
	    RequiredPrecision = 0;

	return (putFloatF(value, fieldwidth, RequiredPrecision, fill));
    } else
	return (putFloatE(value, fieldwidth, RequiredPrecision - 1, fill, ExponentChar));

#undef FIXEDSIZE
#undef EXPSIZE
}


static int ExtractExponent(double *value)
{
    double MagValue;
    int sign;
    int exp;

    if (*value < 0)
	sign = 1, MagValue = -*value;
    else
	sign = 0, MagValue = *value;

    exp = 0;
    if (MagValue < 1.0) {
	while (MagValue * ten_table[24] < 1.0) {
	    exp -= 24;
	    MagValue *= ten_table[24];
	}
	while (MagValue < 1.0) {
	    exp--;
	    MagValue *= 10.0;
	}
    } else {
	while (MagValue >= ten_table[24]) {
	    exp += 24;
	    MagValue /= ten_table[24];
	}
	while (MagValue >= 10.0) {
	    exp++;
	    MagValue /= 10.0;
	}
    }

    *value = sign ? (-MagValue) : MagValue;
    return (exp);
}
#endif				/* __NO_FLOATING_POINT */


static const char *FormatItem(const char *f, va_list * ap, int *count)
{
    int fieldwidth = 0;
    int precision = -1;
    int leftjust = FALSE;
    int radix = 0;
    char pmod = 0;
    char fill = ' ';
    LeadingSign = FALSE;
    UpperCase = FALSE;

    /* Parse printf Flags */
    while (strchr("-+ #0", (int) *f) != NULL) {
	switch (*f++) {
	case '-':
	    leftjust = TRUE;
	    break;
	case '+':
	    LeadingSign = TRUE;
	    break;
	case ' ':
	    fill = ' ';
	case '#':
	    break;
	case '0':
	    fill = '0';
	    break;
	}
    }

/* Parse field width specifier */
    while (_isdigit(*f)) {
	fieldwidth = (fieldwidth * 10) + (*f - '0');
	++f;
    }

/* Parse field precision specifier */
    if (*f == '.') {
	++f;
	precision = 0;
	while (_isdigit(*f)) {
	    precision = (precision * 10) + (*f - '0');
	    ++f;
	}
    }
    while (1) {
	switch (*(f++)) {
	case '\000':
	    return (--f);


	    /* Parse printf_dbm Modifiers */
	case 'h':
	    pmod = 'h';
	    break;
	case 'l':
	    pmod = 'l';
	    break;
	case 'L':
	    pmod = 'L';
	    break;


	    /* Parse printf_dbm Specifier. */
	case 'c':
	    {
		/* char is promoted to int when passed through '...' - ??? */
		char a = va_arg(*ap, int); 

		if (leftjust) {
		    (*PutFunction) ((char) (a & 0x7f));
		    ++(*count);
		}
		if (fieldwidth > 0)
		    *count += PutRepChar(fill, fieldwidth - 1);
		if (!leftjust) {
		    (*PutFunction) ((char) (a & 0x7f));
		    ++(*count);
		}
		return (f);
	    }
	case 'd':
	    radix = -10;
	    break;

#ifndef __NO_FLOATING_POINT
	case 'e':
	case 'E':
	case 'f':
	case 'g':
	case 'G':
	    {
		double a = va_arg(*ap, double);
		if (leftjust)
		    fieldwidth = -fieldwidth;
		if (precision < 0)
		    precision = 6;
		*count += putFloat(a, fieldwidth, precision, fill, *(f - 1));
		return (f);
	    }
#endif				/* __NO_FLOATING_POINT */

	case 'o':
	    radix = 8;
	    break;
	case 's':
	    {
		char *a = va_arg(*ap, char *);

		if (leftjust)
		    *count += PutString((char *) a);
		if (fieldwidth > (int) strlen((char *) a))
		    *count += PutRepChar(fill, fieldwidth - strlen((char *) a));
		if (!leftjust)
		    *count += PutString((char *) a);
		return (f);
	    }
	case 'u':
	    radix = 10;
	    break;
	case 'x':
	    radix = 16;
	    break;
	case 'X':
	    radix = 16;
	    UpperCase = TRUE;
	    break;
	case '%':
	    (*PutFunction) ('%');
	    ++(*count);
	    return (f);
	default:		/* unknown switch! */
	    radix = 3;
	    break;
	}
	if (radix)
	    break;
    }

    if (leftjust)
	fieldwidth = -fieldwidth;
    {
	sl a = va_arg(*ap, sl);
	PutNumber(a, radix, fieldwidth, fill, pmod);
    }
    return (f);
}

static int OutputFunction(const char *f, va_list ap)
{
    int count = 0;

    while (*f) {
	if (*f == '%')
	    f = FormatItem(f + 1, &ap, &count);
	else {
	    (*PutFunction) (*f++);
	    ++count;
	}
    }
    return count;
}



int printf_dbm(const char *f,...)
{
    int count;
    int ipl;
    va_list ap;

    va_start(ap, f);
    ipl = swpipl( 7 );			/* interrupts - might want to print */
    smp_acquire( &print_lock );		/* printf, sprintf not MT-safe */

    PutFunction = PutChar;
    count = OutputFunction(f, ap);

    smp_release( &print_lock );		/* printf, sprintf not MT-safe */
    swpipl( ipl );
    va_end(ap);			/* clean up */
    return count;
}

static void CopyChar(char c)
{
    *FunctionData.Copy.strptr++ = c;
}

int sprintf_dbm(char *str, const char *f,...)
{
    int count;
    int ipl;
    va_list ap;

    va_start(ap, f);
    ipl = swpipl( 7 );			/* interrupts - might want to print */
    smp_acquire( &print_lock );		/* printf, sprintf not MT-safe */

    FunctionData.Copy.strptr = str;
    PutFunction = CopyChar;

    count = OutputFunction(f, ap);

    va_end(ap);			/* clean up */
    *FunctionData.Copy.strptr = '\0';

    smp_release( &print_lock );		/* printf, sprintf not MT-safe */
    swpipl( ipl );
    return count;
}

int vfprintf_dbm(int stream, const char *f, va_list ap)
{
    int val;
    int ipl;
    static uint8 recursing = FALSE;

    ipl = swpipl( 7 );			/* interrupts - might want to print */
    smp_acquire( &print_lock );		/* printf, sprintf not MT-safe */

    if ( recursing )			/* anti-recursion lock */
	return 0;
    recursing = TRUE;
	
    if (stream == stdout_dbm) 		PutFunction = PutChar;
    else				PutFunction = LogChar;

    val = OutputFunction(f, ap);

    smp_release( &print_lock );		/* printf, sprintf not MT-safe */
    swpipl( ipl );

    recursing = FALSE;
    return val;
}


int vsprintf_dbm( char *str, const char *f, va_list ap)
{
    int val;
    int ipl;
    ipl = swpipl( 7 );			/* interrupts - might want to print */
    smp_acquire( &print_lock );		/* printf, sprintf not MT-safe */

    FunctionData.Copy.strptr = str;
    PutFunction = CopyChar;
    val = OutputFunction(f, ap);

    va_end(ap);			/* clean up */
    *FunctionData.Copy.strptr = '\0';

    smp_release( &print_lock );		/* printf, sprintf not MT-safe */
    swpipl( ipl );
    return val;
}

