/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* applet loader from the manufacturing diags. */
/* Begun by Stig Telfer, Alpha Processor Inc, 18 April 1999 */


/* currently, the applet code is linked and downloaded to 8M */
/* the applet must have its entry point at the start of the image */

#include "lib.h"
#include "uilib.h"
#include "memory.h"


/*----------------------------------------------------------------------*/
/* Main routine */

static DBM_STATUS (*applet_entry)(int, char ** ) = (void *)DIAGS_DLD;

DBM_STATUS dld( int argc, char *argv[] )
{
    unsigned *rcvd;
    int i;
    DBM_STATUS sval;
    io_grp grp;
    io_dev xferdev;

    mobo_cls( );
    printf_dbm( "Applet Loader\n" );

    /* Find the most likely place for the download to occurr,
     * typically SROM or a COM port */

    /* Note: sometimes it will be possible to have more than one IO grouping
     * active, which will break these comparisons */
    grp = getty( );
    if ( grp & (GRP_SROM | GRP_COM1 | GRP_COM2) )
    {

	xferdev = grp_input( grp );

    } else {

	grp = getlog( );
	if ( grp & (GRP_SROM | GRP_COM1 | GRP_COM2) )
	{
	    xferdev = grp_input( grp );

	} else {

	    xferdev = DEV_COM1;		/* default transfer device */
	}
    }


    /* download the applet image to its starting place (nb. uncompressed) */
    if (!XReceive( (void *)DIAGS_DLD, xferdev ) )
    {
	printf_dbm( "Failed, sorry!\n" );
	mobo_key( 0 );
	return STATUS_FAILURE;
    }

    printf_dbm("Downloaded data:\n" );
    for ( i = 0, rcvd = (unsigned *)DIAGS_DLD; i < 8; i++, rcvd++ )
    {
	printf_dbm("%d: 0x%08X\n", i, *rcvd );
    }

    printf_dbm("Press any key to make the jump\n");
    mobo_key( 0 );

    /* here we go */
    imb();		/* make I-stream coherent with D-stream */
    sval = applet_entry( argc, argv );		/* NB: don't strip 'dld' arg */

    printf_dbm("Returned to DBM ok, press any key\n");
    mobo_key( 0 );
    return sval;
}


