/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* This file exists for quickly implementing one-off tests.  Thats it. */

#define TRACE_ENABLE

#include "lib.h"
#include "uilib.h"

#include "specifics.h"
#include "northbridge.h"
#include "platform.h"

/*--------------------------------------------------------------------*/
#define IPI0 16				/* arbitrarily chosen */
#define IPI1 17

#define ALPHA_IPI 3			/* bit 3 = 0x08 = alpha IPI */

DBM_STATUS test( int argc, char *argv[] )
{
    int i, irq_no;

    mobo_cls();

    printf_dbm( "Goby Interrupt test\n" );

    goby_irq_dump();

    printf_dbm( "Configuring some interrupt routings\n" );

    for( i=0; i<64; i++ )
    {
	irq_no = i%6;
	goby_map_irq( i, irq_no );
    }
    goby_irq_dump();

    printf_dbm( "Press a key to setup...\n" );
    mobo_key( 0 );
    TRACE( "Setting up\n" );

    plat_intsetup( 1 );

    goby_irq_dump();


    printf_dbm( "Press a key to Map vectors %d, %d for IPIs (%d)\n",
		IPI0, IPI1, ALPHA_IPI );
    mobo_key( 0 );

    TRACE( "Mapping IRQs for Alpha IPI\n" );
    goby_map_irq( IPI0, ALPHA_IPI );
    goby_map_irq( IPI1, ALPHA_IPI );
    goby_irq_dump();

    printf_dbm( "Press a key to enable IRQs CPU0=%d, CPU1=%d...\n",
		IPI0, IPI1 );
    mobo_key( 0 );
    TRACE( "Enabling IRQs on respective processors\n" );
    goby_enable_irq( IPI0, 0 );
    goby_enable_irq( IPI1, 1 );

    goby_irq_dump();

    printf_dbm( "Press a key to (hopefully) send an IPI to CPU 1\n" );
    mobo_key( 0 );
    TRACE( "Sending an IPI to CPU 1...\n" );
    goby_send_irq( IPI1, 1 );

    TRACE( "Completed test\n" );
    printf_dbm( "I wonder if it worked...\n" );
    goby_irq_dump();
    mobo_key(0);
    return STATUS_SUCCESS;
}

