
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <limits.h>
#include <unistd.h>
#include <string.h>
#include <asm/types.h>
#include <linux/i2c-new.h>
#include <linux/i2c-dev.h>

unsigned long ah2uc(char *ah)
{
unsigned char r;
char b[10];
char *e;

b[0] = ah[0];
b[1] = ah[1];
b[2] = 0;

r = strtoul(b, &e, 16);

if (r == ULONG_MAX || *e ) {  // e has to have 0 if the string is correct
	printf("Invalid number %s\n", b);
	exit(1);
}

return r;
}


main(int ac, char **av) 
{
  int file;
  int busnum = 0; 
  int addr = 0x51; /* 7bit I2C address */
  int res, tmp, i, j;
  int dlen; //data string lendth
  char filename[20];
  char drvname[50];
  unsigned char rom[256];
  unsigned short chksum = 0;
  unsigned long adr;
  unsigned long val;

again:
  sprintf(filename, "/dev/i2c%d", busnum);
  if ((file = open(filename, O_RDWR)) < 0) {
	goto errorout;
  }

  if (ioctl(file,I2C_GETDRVNAME,drvname) < 0) {
        goto errorout;
  }
  if (strncmp(drvname, "SMB driver for ALi chipset", 20) != 0) {
        if (busnum == 0) {
                close(file);
                busnum++;
                goto again;
        } else
                goto errorout;
  }

  if (ioctl(file,I2C_SLAVE,addr) < 0) {
        goto errorout;
  }

  if ((res = i2c_smbus_read_byte(file)) < 0) {
        goto errorout;
  }

  // dump rom
  for (i=0; i<256/16; i++) {
	printf("%02X: ", i*16);
	for (j=0; j<16; j++) 
		printf("%02X ", rom[i*16+j] = i2c_smbus_read_byte_data(file, i*16+j));
	printf("\n");
  }

  for (chksum=0, i=0; i<254; i+=2) 
	chksum += (unsigned short)rom[i] + ((unsigned short)rom[i+1] << 8);

  if (chksum != ((unsigned short)rom[254] + ((unsigned short)rom[255] <<8))) 
	printf("Checksum Invalid, Should be %x but %x\n", chksum, 
		((unsigned short)rom[254] + ((unsigned short)rom[255] <<8)));


  if (ac!=3) {
	printf("To write asset info., give arguments\n");
	printf("asset hex-addr hex-data\n");
	printf("ex) asset 3f 003f482062\n");
	exit(1);
  }

// We've got write request
  adr = ah2uc(av[1]);

  if (adr > 253) {
	printf("Address is incorrect %s\n", av[1]);
	exit(0);
  }

  dlen = strlen(av[2]);

  if (dlen != ((dlen>>1) <<1) ) {
	printf("Odd data length\n");
	exit(1);
  }
  
  for(i=0; i < dlen; i+=2) {	// scan data for invalid numbers
	if ((adr + i/2) > 253) {
		printf("Too many data\n");
		exit(1);
	}

	val = ah2uc(av[2]+i);
	if (val > 255) {
		printf("data is incorrect %s\n", av[2]+i);
		exit(0);
	}
  }

  printf("Writing...\n");
  printf("Address %02X: ", adr);
  fflush(stdout);
  for (i=0; i<dlen/2; i++) {
	rom[adr + i] = ah2uc(av[2]+i*2);
	printf("%02X ", rom[adr + i]);
	res = i2c_smbus_write_byte_data(file, adr + i, rom[adr + i] );
	if (res < 0) {
		printf("Write failed\n");
		exit(1);
	}
	fflush(stdout);
	sleep(1); // data book said 10ms but some how it didn't work.
		  // And slow operation make people think this is
		  // a hard work.
  }
  printf("\n");

  for (chksum=0, i=0; i<254; i+=2) 
	chksum += (unsigned short)rom[i] + ((unsigned short)rom[i+1] << 8);

  printf("Writing checksum %x\n", chksum);
  res = i2c_smbus_write_word_data(file, 254, chksum );

  if (res < 0) {
	printf("Checksum Write failed\n");
	exit(1);
  }


  close(file);
  exit(0);

errorout:
	printf("Error :\ncheck if i2c drivers are loaded.\nOr 8582 is not responding\n");
	close(file);

}

