#define NOT_USED	(0)

#define NUM_DEFOPER	(sizeof(def_opcodes)/sizeof(def_opcodes[0]))
static DEFOPER def_opcodes[] = {
    { "ldbu",           OPC32_LDB,              INS_MEM },
    { "ldwu",           OPC32_LDW,              INS_MEM },
    { "ldl",            OPC32_LDL,              INS_MEM },
    { "ldq",            OPC32_LDQ,              INS_MEM },
    { "ldll",           OPC32_LDLL,             INS_MEM },
    { "ldql",           OPC32_LDQL,             INS_MEM },
    { "ldqu",           OPC32_LDQU,             INS_MEM },
    { "ldl_l",          OPC32_LDLL,             INS_MEM },
    { "ldq_l",          OPC32_LDQL,             INS_MEM },
    { "ldq_u",          OPC32_LDQU,             INS_MEM },
    { "lda",            OPC32_LDA,              INS_MEM },
    { "stb",            OPC32_STB,              INS_MEM },
    { "stw",            OPC32_STW,              INS_MEM },
    { "stl",            OPC32_STL,              INS_MEM },
    { "stq",            OPC32_STQ,              INS_MEM },
    { "stlc",           OPC32_STLC,             INS_MEM },
    { "stqc",           OPC32_STQC,             INS_MEM },
    { "stqu",           OPC32_STQU,             INS_MEM },
    { "stl_c",          OPC32_STLC,             INS_MEM },
    { "stq_c",          OPC32_STQC,             INS_MEM },
    { "stq_u",          OPC32_STQU,             INS_MEM },
    { "ldah",           OPC32_LDAH,             INS_MEM },
    { "ldf",            OPC32_LDF,              INS_MEM },
    { "ldd",            OPC32_LDD,              INS_MEM },
    { "ldg",            OPC32_LDD,              INS_MEM },
    { "lds",            OPC32_LDS,              INS_MEM },
    { "ldt",            OPC32_LDT,              INS_MEM },
    { "stf",            OPC32_STF,              INS_MEM },
    { "std",            OPC32_STD,              INS_MEM },
    { "stg",            OPC32_STD,              INS_MEM },
    { "sts",            OPC32_STS,              INS_MEM },
    { "stt",            OPC32_STT,              INS_MEM },

    { "addl",           OPC32_ADDL,             INS_IOP },
    { "addlv",          OPC32_ADDLV,            INS_IOP },
    { "addq",           OPC32_ADDQ,             INS_IOP },
    { "addqv",          OPC32_ADDQV,            INS_IOP },
    { "s4addl",         OPC32_S4ADDL,           INS_IOP },
    { "s4addq",         OPC32_S4ADDQ,           INS_IOP },
    { "s8addl",         OPC32_S8ADDL,           INS_IOP },
    { "s8addq",         OPC32_S8ADDQ,           INS_IOP },
    { "s4subl",         OPC32_S4SUBL,           INS_IOP },
    { "s4subq",         OPC32_S4SUBQ,           INS_IOP },
    { "s8subl",         OPC32_S8SUBL,           INS_IOP },
    { "s8subq",         OPC32_S8SUBQ,           INS_IOP },
    { "subl",           OPC32_SUBL,             INS_IOP },
    { "sublv",          OPC32_SUBLV,            INS_IOP },
    { "subq",           OPC32_SUBQ,             INS_IOP },
    { "subqv",          OPC32_SUBQV,            INS_IOP },
    { "cmpeq",          OPC32_CMPEQ,            INS_IOP },
    { "cmplt",          OPC32_CMPLT,            INS_IOP },
    { "cmple",          OPC32_CMPLE,            INS_IOP },
    { "cmpult",         OPC32_CMPULT,           INS_IOP },
    { "cmpule",         OPC32_CMPULE,           INS_IOP },
    { "cmpbge",         OPC32_CMPBGE,           INS_IOP },
    { "and",            OPC32_AND,              INS_IOP },
    { "bic",            OPC32_BIC,              INS_IOP },
    { "cmoveq",         OPC32_CMOVEQ,           INS_IOP },
    { "cmovne",         OPC32_CMOVNE,           INS_IOP },

    { "ornot",          OPC32_ORNOT,            INS_IOP },

    { "bis",            OPC32_BIS,              INS_IOP },
    { "or",             OPC32_BIS,              INS_IOP },

    { "cmovlt",         OPC32_CMOVLT,           INS_IOP },
    { "cmovge",         OPC32_CMOVGE,           INS_IOP },
    { "xor",            OPC32_XOR,              INS_IOP },
    { "eqv",            OPC32_EQV,              INS_IOP },
    { "amask",          OPC32_AMASK,            INS_SEXT },
    { "implver",        OPC32_IMPLVER,          INS_1REG },
    { "cmovle",         OPC32_CMOVLE,           INS_IOP },
    { "cmovgt",         OPC32_CMOVGT,           INS_IOP },
    { "cmovlbs",        OPC32_CMOVLBS,          INS_IOP },
    { "cmovlbc",        OPC32_CMOVLBC,          INS_IOP },
    { "extbl",          OPC32_EXTBL,            INS_IOP },
    { "extwl",          OPC32_EXTWL,            INS_IOP },
    { "extll",          OPC32_EXTLL,            INS_IOP },
    { "extql",          OPC32_EXTQL,            INS_IOP },
    { "extwh",          OPC32_EXTWH,            INS_IOP },
    { "extlh",          OPC32_EXTLH,            INS_IOP },
    { "extqh",          OPC32_EXTQH,            INS_IOP },
    { "insbl",          OPC32_INSBL,            INS_IOP },
    { "inswl",          OPC32_INSWL,            INS_IOP },
    { "insll",          OPC32_INSLL,            INS_IOP },
    { "insql",          OPC32_INSQL,            INS_IOP },
    { "inswh",          OPC32_INSWH,            INS_IOP },
    { "inslh",          OPC32_INSLH,            INS_IOP },
    { "insqh",          OPC32_INSQH,            INS_IOP },
    { "mskbl",          OPC32_MSKBL,            INS_IOP },
    { "mskwl",          OPC32_MSKWL,            INS_IOP },
    { "mskll",          OPC32_MSKLL,            INS_IOP },
    { "mskql",          OPC32_MSKQL,            INS_IOP },
    { "mskwh",          OPC32_MSKWH,            INS_IOP },
    { "msklh",          OPC32_MSKLH,            INS_IOP },
    { "mskqh",          OPC32_MSKQH,            INS_IOP },
    { "zap",            OPC32_ZAP,              INS_IOP },
    { "zapnot",         OPC32_ZAPNOT,           INS_IOP },
    { "sra",            OPC32_SRA,              INS_IOP },
    { "srl",            OPC32_SRL,              INS_IOP },
    { "sll",            OPC32_SLL,              INS_IOP },
    
    { "sextb",          OPC32_SEXTB,            INS_SEXT },
    { "sextw",          OPC32_SEXTW,            INS_SEXT },
    { "ctpop",          OPC32_CTPOP,            INS_SEXT },
    { "ctlz",           OPC32_CTLZ,             INS_IP2 },
    { "cttz",           OPC32_CTTZ,             INS_IP2 },
    { "perr",           OPC32_PERR,             INS_IP3 },
    { "minub8",         OPC32_MINUB8,           INS_IOP },
    { "minuw4",         OPC32_MINUW4,           INS_IOP },
    { "minsb8",         OPC32_MINSB8,           INS_IOP },
    { "minsw4",         OPC32_MINSW4,           INS_IOP },
    { "maxub8",         OPC32_MAXUB8,           INS_IOP },
    { "maxuw4",         OPC32_MAXUW4,           INS_IOP },
    { "maxsb8",         OPC32_MAXSB8,           INS_IOP },
    { "maxsw4",         OPC32_MAXSW4,           INS_IOP },
    { "unpkbw",         OPC32_UNPKBW,           INS_IP2 },
    { "unpkbl",         OPC32_UNPKBL,           INS_IP2 },
    { "pkwb",           OPC32_PKWB,             INS_IP2 },
    { "pklb",           OPC32_PKLB,             INS_IP2 },
    { "wh64",           OPC32_WH64,             INS_M1B },
    { "ecb",            OPC32_ECB,              INS_M1B },
    { "ftoit",          OPC32_FTOIT,            INS_FTI },
    { "ftois",          OPC32_FTOIS,            INS_FTI },

/* These no longer exist 
    { "ldwsb",          OPC32_LDWSB,            INS_LSB },
    { "ldlsb",          OPC32_LDLSB,            INS_LSB },
    { "ldqsb",          OPC32_LDQSB,            INS_LSB },
    { "stwsb",          OPC32_STWSB,            INS_SSB },
    { "stlsb",          OPC32_STLSB,            INS_SSB },
    { "stqsb",          OPC32_STQSB,            INS_SSB },
*/
    
    { "nop",            OPC32_NOP,              INS_MIS },
    { "fnop",           OPC32_FNOP,             INS_MIS },
    { "unop",           OPC32_UNOP,             INS_UNOP },
    
    { "mull",           OPC32_MULL,             INS_IOP },
    { "mulqv",          OPC32_MULQV,            INS_IOP },
    { "mullv",          OPC32_MULLV,            INS_IOP },
    { "umulh",          OPC32_UMULH,            INS_IOP },
    { "mulq",           OPC32_MULQ,             INS_IOP },

    { "jmp",            OPC32_JMP,              INS_JSR },
    { "jsr",            OPC32_JSR,              INS_JSR },
    { "ret",            OPC32_RET,              INS_JSR },
    { "jsr_coroutine",  OPC32_JSR_COROUTINE,    INS_JSR },

    { "br",             OPC32_BR,               INS_BRN },
    { "bsr",            OPC32_BSR,              INS_BRN },
    { "blbc",           OPC32_BLBC,             INS_BRN },
    { "blbs",           OPC32_BLBS,             INS_BRN },
    { "fbeq",           OPC32_FBEQ,             INS_BRN },
    { "fbne",           OPC32_FBNE,             INS_BRN },
    { "beq",            OPC32_BEQ,              INS_BRN },
    { "bne",            OPC32_BNE,              INS_BRN },
    { "fblt",           OPC32_FBLT,             INS_BRN },
    { "fbge",           OPC32_FBGE,             INS_BRN },
    { "blt",            OPC32_BLT,              INS_BRN },
    { "bge",            OPC32_BGE,              INS_BRN },
    { "fble",           OPC32_FBLE,             INS_BRN },
    { "fbgt",           OPC32_FBGT,             INS_BRN },
    { "ble",            OPC32_BLE,              INS_BRN },
    { "bgt",            OPC32_BGT,              INS_BRN },

    { "cpys",           OPC32_CPYS,             INS_FOP },
    { "cpysn",          OPC32_CPYSN,            INS_FOP },
    { "cpyse",          OPC32_CPYSE,            INS_FOP },
    { "cpysee",         OPC32_CPYSEE,           INS_FOP },

    { "wr_fpctl",       OPC32_WR_FPCTL,         INS_FPCR },
    { "rd_fpctl",       OPC32_RD_FPCTL,         INS_FPCR },
    { "mt_fpctl",       OPC32_WR_FPCTL,         INS_FPCR },
    { "mf_fpctl",       OPC32_RD_FPCTL,         INS_FPCR },
    { "mt_fpcr",        OPC32_WR_FPCTL,         INS_FPCR },
    { "mf_fpcr",        OPC32_RD_FPCTL,         INS_FPCR },

    { "cvtlq",          OPC32_CVTLQ,            INS_FP2 },
    { "cvtql",          OPC32_CVTQL,            INS_FP2 },
    { "cvtqlv",         OPC32_CVTQLV,           INS_FP2 },
    { "cvtqlsv",        OPC32_CVTQLSV,          INS_FP2 },

    { "fcmoveq",        OPC32_FCMOVEQ,          INS_FOP },
    { "fcmovne",        OPC32_FCMOVNE,          INS_FOP },
    { "fcmovlt",        OPC32_FCMOVLT,          INS_FOP },
    { "fcmovge",        OPC32_FCMOVGE,          INS_FOP },
    { "fcmovle",        OPC32_FCMOVLE,          INS_FOP },
    { "fcmovgt",        OPC32_FCMOVGT,          INS_FOP },

    { "adds",           OPC32_ADDS,             INS_FOP },
    { "addsc",          OPC32_ADDSC,            INS_FOP },
    { "addsm",          OPC32_ADDSM,            INS_FOP },
    { "addsd",          OPC32_ADDSP,            INS_FOP },
    { "addsp",          OPC32_ADDSP,            INS_FOP },
    { "addsu",          OPC32_ADDSU,            INS_FOP },
    { "addsuc",         OPC32_ADDSUC,           INS_FOP },
    { "addsum",         OPC32_ADDSUM,           INS_FOP },
    { "addsud",         OPC32_ADDSUP,           INS_FOP },
    { "addsup",         OPC32_ADDSUP,           INS_FOP },
    { "addss",          OPC32_ADDSS,            INS_FOP },
    { "addssc",         OPC32_ADDSSC,           INS_FOP },
    { "addssm",         OPC32_ADDSSM,           INS_FOP },
    { "addssd",         OPC32_ADDSSP,           INS_FOP },
    { "addssp",         OPC32_ADDSSP,           INS_FOP },
    { "addssu",         OPC32_ADDSSU,           INS_FOP },
    { "addssuc",        OPC32_ADDSSUC,          INS_FOP },
    { "addssum",        OPC32_ADDSSUM,          INS_FOP },
    { "addssud",        OPC32_ADDSSUP,          INS_FOP },
    { "addssup",        OPC32_ADDSSUP,          INS_FOP },
    { "addssui",        OPC32_ADDSSUI,          INS_FOP },
    { "addssuic",       OPC32_ADDSSUIC,         INS_FOP },
    { "addssuim",       OPC32_ADDSSUIM,         INS_FOP },
    { "addssuid",       OPC32_ADDSSUIP,         INS_FOP },
    { "addssuip",       OPC32_ADDSSUIP,         INS_FOP },
    { "addt",           OPC32_ADDT,             INS_FOP },
    { "addtc",          OPC32_ADDTC,            INS_FOP },
    { "addtm",          OPC32_ADDTM,            INS_FOP },
    { "addtd",          OPC32_ADDTP,            INS_FOP },
    { "addtp",          OPC32_ADDTP,            INS_FOP },
    { "addtu",          OPC32_ADDTU,            INS_FOP },
    { "addtuc",         OPC32_ADDTUC,           INS_FOP },
    { "addtum",         OPC32_ADDTUM,           INS_FOP },
    { "addtud",         OPC32_ADDTUP,           INS_FOP },
    { "addtup",         OPC32_ADDTUP,           INS_FOP },
    { "addts",          OPC32_ADDTS,            INS_FOP },
    { "addtsc",         OPC32_ADDTSC,           INS_FOP },
    { "addtsm",         OPC32_ADDTSM,           INS_FOP },
    { "addtsd",         OPC32_ADDTSP,           INS_FOP },
    { "addtsp",         OPC32_ADDTSP,           INS_FOP },
    { "addtsu",         OPC32_ADDTSU,           INS_FOP },
    { "addtsuc",        OPC32_ADDTSUC,          INS_FOP },
    { "addtsum",        OPC32_ADDTSUM,          INS_FOP },
    { "addtsud",        OPC32_ADDTSUP,          INS_FOP },
    { "addtsup",        OPC32_ADDTSUP,          INS_FOP },
    { "addtsui",        OPC32_ADDTSUI,          INS_FOP },
    { "addtsuic",       OPC32_ADDTSUIC,         INS_FOP },
    { "addtsuim",       OPC32_ADDTSUIM,         INS_FOP },
    { "addtsuid",       OPC32_ADDTSUIP,         INS_FOP },
    { "addtsuip",       OPC32_ADDTSUIP,         INS_FOP },

    { "cmpteq",         OPC32_CMPTEQ,           INS_FOP },
    { "cmpteqsu",       OPC32_CMPTEQSU,         INS_FOP },
    { "cmptlt",         OPC32_CMPTLT,           INS_FOP },
    { "cmptltsu",       OPC32_CMPTLTSU,         INS_FOP },
    { "cmptle",         OPC32_CMPTLE,           INS_FOP },
    { "cmptlesu",       OPC32_CMPTLESU,         INS_FOP },
    { "cmptun",         OPC32_CMPTUN,           INS_FOP },
    { "cmptunsu",       OPC32_CMPTUNSU,         INS_FOP },

    { "cvtqs",          OPC32_CVTQS,            INS_FP2 },
    { "cvtqsc",         OPC32_CVTQSC,           INS_FP2 },
    { "cvtqsm",         OPC32_CVTQSM,           INS_FP2 },
    { "cvtqsd",         OPC32_CVTQSP,           INS_FP2 },
    { "cvtqsp",         OPC32_CVTQSP,           INS_FP2 },
    { "cvtqssui",       OPC32_CVTQSSUI,         INS_FP2 },
    { "cvtqssuic",      OPC32_CVTQSSUIC,        INS_FP2 },
    { "cvtqssuim",      OPC32_CVTQSSUIM,        INS_FP2 },
    { "cvtqssuid",      OPC32_CVTQSSUIP,        INS_FP2 },
    { "cvtqssuip",      OPC32_CVTQSSUIP,        INS_FP2 },
    { "cvtqt",          OPC32_CVTQT,            INS_FP2 },
    { "cvtqtc",         OPC32_CVTQTC,           INS_FP2 },
    { "cvtqtm",         OPC32_CVTQTM,           INS_FP2 },
    { "cvtqtd",         OPC32_CVTQTP,           INS_FP2 },
    { "cvtqtp",         OPC32_CVTQTP,           INS_FP2 },
    { "cvtqtsui",       OPC32_CVTQTSUI,         INS_FP2 },
    { "cvtqtsuic",      OPC32_CVTQTSUIC,        INS_FP2 },
    { "cvtqtsuim",      OPC32_CVTQTSUIM,        INS_FP2 },
    { "cvtqtsuid",      OPC32_CVTQTSUIP,        INS_FP2 },
    { "cvtqtsuip",      OPC32_CVTQTSUIP,        INS_FP2 },
    { "cvtst",          OPC32_CVTST,            INS_FP2 },
    { "cvtsts",         OPC32_CVTSTS,           INS_FP2 },
    { "cvtts",          OPC32_CVTTS,            INS_FP2 },
    { "cvttsc",         OPC32_CVTTSC,           INS_FP2 },
    { "cvttsm",         OPC32_CVTTSM,           INS_FP2 },
    { "cvttsd",         OPC32_CVTTSP,           INS_FP2 },
    { "cvttsp",         OPC32_CVTTSP,           INS_FP2 },
    { "cvttsu",         OPC32_CVTTSU,           INS_FP2 },
    { "cvttsuc",        OPC32_CVTTSUC,          INS_FP2 },
    { "cvttsum",        OPC32_CVTTSUM,          INS_FP2 },
    { "cvttsud",        OPC32_CVTTSUP,          INS_FP2 },
    { "cvttsup",        OPC32_CVTTSUP,          INS_FP2 },
    { "cvttss",         OPC32_CVTTSS,           INS_FP2 },
    { "cvttssc",        OPC32_CVTTSSC,          INS_FP2 },
    { "cvttssm",        OPC32_CVTTSSM,          INS_FP2 },
    { "cvttssd",        OPC32_CVTTSSP,          INS_FP2 },
    { "cvttssp",        OPC32_CVTTSSP,          INS_FP2 },
    { "cvttssu",        OPC32_CVTTSSU,          INS_FP2 },
    { "cvttssuc",       OPC32_CVTTSSUC,         INS_FP2 },
    { "cvttssum",       OPC32_CVTTSSUM,         INS_FP2 },
    { "cvttssud",       OPC32_CVTTSSUP,         INS_FP2 },
    { "cvttssup",       OPC32_CVTTSSUP,         INS_FP2 },
    { "cvttssui",       OPC32_CVTTSSUI,         INS_FP2 },
    { "cvttssuic",      OPC32_CVTTSSUIC,        INS_FP2 },
    { "cvttssuim",      OPC32_CVTTSSUIM,        INS_FP2 },
    { "cvttssuid",      OPC32_CVTTSSUIP,        INS_FP2 },
    { "cvttssuip",      OPC32_CVTTSSUIP,        INS_FP2 },

    { "divs",           OPC32_DIVS,             INS_FOP },
    { "divsc",          OPC32_DIVSC,            INS_FOP },
    { "divsm",          OPC32_DIVSM,            INS_FOP },
    { "divsd",          OPC32_DIVSP,            INS_FOP },
    { "divsp",          OPC32_DIVSP,            INS_FOP },
    { "divsu",          OPC32_DIVSU,            INS_FOP },
    { "divsuc",         OPC32_DIVSUC,           INS_FOP },
    { "divsum",         OPC32_DIVSUM,           INS_FOP },
    { "divsud",         OPC32_DIVSUP,           INS_FOP },
    { "divsup",         OPC32_DIVSUP,           INS_FOP },
    { "divss",          OPC32_DIVSS,            INS_FOP },
    { "divssc",         OPC32_DIVSSC,           INS_FOP },
    { "divssm",         OPC32_DIVSSM,           INS_FOP },
    { "divssd",         OPC32_DIVSSP,           INS_FOP },
    { "divssp",         OPC32_DIVSSP,           INS_FOP },
    { "divssu",         OPC32_DIVSSU,           INS_FOP },
    { "divssuc",        OPC32_DIVSSUC,          INS_FOP },
    { "divssum",        OPC32_DIVSSUM,          INS_FOP },
    { "divssud",        OPC32_DIVSSUP,          INS_FOP },
    { "divssup",        OPC32_DIVSSUP,          INS_FOP },
    { "divssui",        OPC32_DIVSSUI,          INS_FOP },
    { "divssuic",       OPC32_DIVSSUIC,         INS_FOP },
    { "divssuim",       OPC32_DIVSSUIM,         INS_FOP },
    { "divssuid",       OPC32_DIVSSUIP,         INS_FOP },
    { "divssuip",       OPC32_DIVSSUIP,         INS_FOP },
    { "divt",           OPC32_DIVT,             INS_FOP },
    { "divtc",          OPC32_DIVTC,            INS_FOP },
    { "divtm",          OPC32_DIVTM,            INS_FOP },
    { "divtd",          OPC32_DIVTP,            INS_FOP },
    { "divtp",          OPC32_DIVTP,            INS_FOP },
    { "divtu",          OPC32_DIVTU,            INS_FOP },
    { "divtuc",         OPC32_DIVTUC,           INS_FOP },
    { "divtum",         OPC32_DIVTUM,           INS_FOP },
    { "divtud",         OPC32_DIVTUP,           INS_FOP },
    { "divtup",         OPC32_DIVTUP,           INS_FOP },
    { "divts",          OPC32_DIVTS,            INS_FOP },
    { "divtsc",         OPC32_DIVTSC,           INS_FOP },
    { "divtsm",         OPC32_DIVTSM,           INS_FOP },
    { "divtsd",         OPC32_DIVTSP,           INS_FOP },
    { "divtsp",         OPC32_DIVTSP,           INS_FOP },
    { "divtsu",         OPC32_DIVTSU,           INS_FOP },
    { "divtsuc",        OPC32_DIVTSUC,          INS_FOP },
    { "divtsum",        OPC32_DIVTSUM,          INS_FOP },
    { "divtsud",        OPC32_DIVTSUP,          INS_FOP },
    { "divtsup",        OPC32_DIVTSUP,          INS_FOP },
    { "divtsui",        OPC32_DIVTSUI,          INS_FOP },
    { "divtsuic",       OPC32_DIVTSUIC,         INS_FOP },
    { "divtsuim",       OPC32_DIVTSUIM,         INS_FOP },
    { "divtsuid",       OPC32_DIVTSUIP,         INS_FOP },
    { "divtsuip",       OPC32_DIVTSUIP,         INS_FOP },

    { "muls",           OPC32_MULS,             INS_FOP },
    { "mulsc",          OPC32_MULSC,            INS_FOP },
    { "mulsm",          OPC32_MULSM,            INS_FOP },
    { "mulsd",          OPC32_MULSP,            INS_FOP },
    { "mulsp",          OPC32_MULSP,            INS_FOP },
    { "mulsu",          OPC32_MULSU,            INS_FOP },
    { "mulsuc",         OPC32_MULSUC,           INS_FOP },
    { "mulsum",         OPC32_MULSUM,           INS_FOP },
    { "mulsud",         OPC32_MULSUP,           INS_FOP },
    { "mulsup",         OPC32_MULSUP,           INS_FOP },
    { "mulss",          OPC32_MULSS,            INS_FOP },
    { "mulssc",         OPC32_MULSSC,           INS_FOP },
    { "mulssm",         OPC32_MULSSM,           INS_FOP },
    { "mulssd",         OPC32_MULSSP,           INS_FOP },
    { "mulssp",         OPC32_MULSSP,           INS_FOP },
    { "mulssu",         OPC32_MULSSU,           INS_FOP },
    { "mulssuc",        OPC32_MULSSUC,          INS_FOP },
    { "mulssum",        OPC32_MULSSUM,          INS_FOP },
    { "mulssud",        OPC32_MULSSUP,          INS_FOP },
    { "mulssup",        OPC32_MULSSUP,          INS_FOP },
    { "mulssui",        OPC32_MULSSUI,          INS_FOP },
    { "mulssuic",       OPC32_MULSSUIC,         INS_FOP },
    { "mulssuim",       OPC32_MULSSUIM,         INS_FOP },
    { "mulssuid",       OPC32_MULSSUIP,         INS_FOP },
    { "mulssuip",       OPC32_MULSSUIP,         INS_FOP },
    { "mult",           OPC32_MULT,             INS_FOP },
    { "multc",          OPC32_MULTC,            INS_FOP },
    { "multm",          OPC32_MULTM,            INS_FOP },
    { "multd",          OPC32_MULTP,            INS_FOP },
    { "multp",          OPC32_MULTP,            INS_FOP },
    { "multu",          OPC32_MULTU,            INS_FOP },
    { "multuc",         OPC32_MULTUC,           INS_FOP },
    { "multum",         OPC32_MULTUM,           INS_FOP },
    { "multud",         OPC32_MULTUP,           INS_FOP },
    { "multup",         OPC32_MULTUP,           INS_FOP },
    { "mults",          OPC32_MULTS,            INS_FOP },
    { "multsc",         OPC32_MULTSC,           INS_FOP },
    { "multsm",         OPC32_MULTSM,           INS_FOP },
    { "multsd",         OPC32_MULTSP,           INS_FOP },
    { "multsp",         OPC32_MULTSP,           INS_FOP },
    { "multsu",         OPC32_MULTSU,           INS_FOP },
    { "multsuc",        OPC32_MULTSUC,          INS_FOP },
    { "multsum",        OPC32_MULTSUM,          INS_FOP },
    { "multsud",        OPC32_MULTSUP,          INS_FOP },
    { "multsup",        OPC32_MULTSUP,          INS_FOP },
    { "multsui",        OPC32_MULTSUI,          INS_FOP },
    { "multsuic",       OPC32_MULTSUIC,         INS_FOP },
    { "multsuim",       OPC32_MULTSUIM,         INS_FOP },
    { "multsuid",       OPC32_MULTSUIP,         INS_FOP },
    { "multsuip",       OPC32_MULTSUIP,         INS_FOP },

    { "subs",           OPC32_SUBS,             INS_FOP },
    { "subsc",          OPC32_SUBSC,            INS_FOP },
    { "subsm",          OPC32_SUBSM,            INS_FOP },
    { "subsd",          OPC32_SUBSP,            INS_FOP },
    { "subsp",          OPC32_SUBSP,            INS_FOP },
    { "subsu",          OPC32_SUBSU,            INS_FOP },
    { "subsuc",         OPC32_SUBSUC,           INS_FOP },
    { "subsum",         OPC32_SUBSUM,           INS_FOP },
    { "subsud",         OPC32_SUBSUP,           INS_FOP },
    { "subsup",         OPC32_SUBSUP,           INS_FOP },
    { "subss",          OPC32_SUBSS,            INS_FOP },
    { "subssc",         OPC32_SUBSSC,           INS_FOP },
    { "subssm",         OPC32_SUBSSM,           INS_FOP },
    { "subssd",         OPC32_SUBSSP,           INS_FOP },
    { "subssp",         OPC32_SUBSSP,           INS_FOP },
    { "subssu",         OPC32_SUBSSU,           INS_FOP },
    { "subssuc",        OPC32_SUBSSUC,          INS_FOP },
    { "subssum",        OPC32_SUBSSUM,          INS_FOP },
    { "subssud",        OPC32_SUBSSUP,          INS_FOP },
    { "subssup",        OPC32_SUBSSUP,          INS_FOP },
    { "subssui",        OPC32_SUBSSUI,          INS_FOP },
    { "subssuic",       OPC32_SUBSSUIC,         INS_FOP },
    { "subssuim",       OPC32_SUBSSUIM,         INS_FOP },
    { "subssuid",       OPC32_SUBSSUIP,         INS_FOP },
    { "subssuip",       OPC32_SUBSSUIP,         INS_FOP },
    { "subt",           OPC32_SUBT,             INS_FOP },
    { "subtc",          OPC32_SUBTC,            INS_FOP },
    { "subtm",          OPC32_SUBTM,            INS_FOP },
    { "subtd",          OPC32_SUBTP,            INS_FOP },
    { "subtp",          OPC32_SUBTP,            INS_FOP },
    { "subtu",          OPC32_SUBTU,            INS_FOP },
    { "subtuc",         OPC32_SUBTUC,           INS_FOP },
    { "subtum",         OPC32_SUBTUM,           INS_FOP },
    { "subtud",         OPC32_SUBTUP,           INS_FOP },
    { "subtup",         OPC32_SUBTUP,           INS_FOP },
    { "subts",          OPC32_SUBTS,            INS_FOP },
    { "subtsc",         OPC32_SUBTSC,           INS_FOP },
    { "subtsm",         OPC32_SUBTSM,           INS_FOP },
    { "subtsd",         OPC32_SUBTSP,           INS_FOP },
    { "subtsp",         OPC32_SUBTSP,           INS_FOP },
    { "subtsu",         OPC32_SUBTSU,           INS_FOP },
    { "subtsuc",        OPC32_SUBTSUC,          INS_FOP },
    { "subtsum",        OPC32_SUBTSUM,          INS_FOP },
    { "subtsud",        OPC32_SUBTSUP,          INS_FOP },
    { "subtsup",        OPC32_SUBTSUP,          INS_FOP },
    { "subtsui",        OPC32_SUBTSUI,          INS_FOP },
    { "subtsuic",       OPC32_SUBTSUIC,         INS_FOP },
    { "subtsuim",       OPC32_SUBTSUIM,         INS_FOP },
    { "subtsuid",       OPC32_SUBTSUIP,         INS_FOP },
    { "subtsuip",       OPC32_SUBTSUIP,         INS_FOP },

    { "cvttq",          OPC32_CVTTQ,            INS_FP2 },
    { "cvttqc",         OPC32_CVTTQC,           INS_FP2 },
    { "cvttqv",         OPC32_CVTTQV,           INS_FP2 },
    { "cvttqvc",        OPC32_CVTTQVC,          INS_FP2 },
    { "cvttqsv",        OPC32_CVTTQSV,          INS_FP2 },
    { "cvttqsvc",       OPC32_CVTTQSVC,         INS_FP2 },
    { "cvttqsvi",       OPC32_CVTTQSVI,         INS_FP2 },
    { "cvttqsvic",      OPC32_CVTTQSVIC,        INS_FP2 },
    { "cvttqd",         OPC32_CVTTQD,           INS_FP2 },
    { "cvttqvd",        OPC32_CVTTQVD,          INS_FP2 },
    { "cvttqsvd",       OPC32_CVTTQSVD,         INS_FP2 },
    { "cvttqsvid",      OPC32_CVTTQSVID,        INS_FP2 },
    { "cvttqp",         OPC32_CVTTQD,           INS_FP2 },
    { "cvttqvp",        OPC32_CVTTQVD,          INS_FP2 },
    { "cvttqsvp",       OPC32_CVTTQSVD,         INS_FP2 },
    { "cvttqsvip",      OPC32_CVTTQSVID,        INS_FP2 },
    { "cvttqm",         OPC32_CVTTQM,           INS_FP2 },
    { "cvttqvm",        OPC32_CVTTQVM,          INS_FP2 },
    { "cvttqsvm",       OPC32_CVTTQSVM,         INS_FP2 },
    { "cvttqsvim",      OPC32_CVTTQSVIM,        INS_FP2 },
    { "cvttqs",         OPC32_CVTTQS,           INS_FP2 },
    { "cvttqsc",        OPC32_CVTTQSC,          INS_FP2 },
    { "cvttqsm",        OPC32_CVTTQSM,          INS_FP2 },
    { "cvttqsd",        OPC32_CVTTQSD,          INS_FP2 },
    { "cvttqsp",        OPC32_CVTTQSD,          INS_FP2 },

    { "itoft",          OPC32_ITOFT,            INS_ITF },
    { "itofs",          OPC32_ITOFS,            INS_ITF },
    { "itoff",          OPC32_ITOFF,            INS_ITF },
    { "sqrts",          OPC32_SQRTS,            INS_FP2 },
    { "sqrtsc",         OPC32_SQRTSC,           INS_FP2 },
    { "sqrtsm",         OPC32_SQRTSM,           INS_FP2 },
    { "sqrtsd",         OPC32_SQRTSD,           INS_FP2 },
    { "sqrtsp",         OPC32_SQRTSD,           INS_FP2 },
    { "sqrtsu",         OPC32_SQRTSU,           INS_FP2 },
    { "sqrtsuc",        OPC32_SQRTSUC,          INS_FP2 },
    { "sqrtsum",        OPC32_SQRTSUM,          INS_FP2 },
    { "sqrtsud",        OPC32_SQRTSUD,          INS_FP2 },
    { "sqrtsup",        OPC32_SQRTSUD,          INS_FP2 },
    { "sqrtssu",        OPC32_SQRTSSU,          INS_FP2 },
    { "sqrtssuc",       OPC32_SQRTSSUC,         INS_FP2 },
    { "sqrtssum",       OPC32_SQRTSSUM,         INS_FP2 },
    { "sqrtssud",       OPC32_SQRTSSUD,         INS_FP2 },
    { "sqrtssup",       OPC32_SQRTSSUD,         INS_FP2 },
    { "sqrtssui",       OPC32_SQRTSSUI,         INS_FP2 },
    { "sqrtssuic",      OPC32_SQRTSSUIC,        INS_FP2 },
    { "sqrtssuim",      OPC32_SQRTSSUIM,        INS_FP2 },
    { "sqrtssuid",      OPC32_SQRTSSUID,        INS_FP2 },
    { "sqrtssuip",      OPC32_SQRTSSUID,        INS_FP2 },
    { "sqrtt",          OPC32_SQRTT,            INS_FP2 },
    { "sqrttc",         OPC32_SQRTTC,           INS_FP2 },
    { "sqrttm",         OPC32_SQRTTM,           INS_FP2 },
    { "sqrttd",         OPC32_SQRTTD,           INS_FP2 },
    { "sqrttp",         OPC32_SQRTTD,           INS_FP2 },
    { "sqrttu",         OPC32_SQRTTU,           INS_FP2 },
    { "sqrttuc",        OPC32_SQRTTUC,          INS_FP2 },
    { "sqrttum",        OPC32_SQRTTUM,          INS_FP2 },
    { "sqrttud",        OPC32_SQRTTUD,          INS_FP2 },
    { "sqrttup",        OPC32_SQRTTUD,          INS_FP2 },
    { "sqrttsu",        OPC32_SQRTTSU,          INS_FP2 },
    { "sqrttsuc",       OPC32_SQRTTSUC,         INS_FP2 },
    { "sqrttsum",       OPC32_SQRTTSUM,         INS_FP2 },
    { "sqrttsud",       OPC32_SQRTTSUD,         INS_FP2 },
    { "sqrttsup",       OPC32_SQRTTSUD,         INS_FP2 },
    { "sqrttsui",       OPC32_SQRTTSUI,         INS_FP2 },
    { "sqrttsuic",      OPC32_SQRTTSUIC,        INS_FP2 },
    { "sqrttsuim",      OPC32_SQRTTSUIM,        INS_FP2 },
    { "sqrttsuid",      OPC32_SQRTTSUID,        INS_FP2 },
    { "sqrttsuip",      OPC32_SQRTTSUID,        INS_FP2 },

    { "addf",           OPC32_ADDF,             INS_FOP },
    { "addfc",          OPC32_ADDFC,            INS_FOP },
    { "addfu",          OPC32_ADDFU,            INS_FOP },
    { "addfuc",         OPC32_ADDFUC,           INS_FOP },
    { "addfs",          OPC32_ADDFS,            INS_FOP },
    { "addfsc",         OPC32_ADDFSC,           INS_FOP },
    { "addfsu",         OPC32_ADDFSU,           INS_FOP },
    { "addfsuc",        OPC32_ADDFSUC,          INS_FOP },
    { "addg",           OPC32_ADDG,             INS_FOP },
    { "addgc",          OPC32_ADDGC,            INS_FOP },
    { "addgu",          OPC32_ADDGU,            INS_FOP },
    { "addguc",         OPC32_ADDGUC,           INS_FOP },
    { "addgs",          OPC32_ADDGS,            INS_FOP },
    { "addgsc",         OPC32_ADDGSC,           INS_FOP },
    { "addgsu",         OPC32_ADDGSU,           INS_FOP },
    { "addgsuc",        OPC32_ADDGSUC,          INS_FOP },

    { "cmpgeq",         OPC32_CMPGEQ,           INS_FOP },
    { "cmpglt",         OPC32_CMPGLT,           INS_FOP },
    { "cmpgle",         OPC32_CMPGLE,           INS_FOP },
    { "cmpgeqs",        OPC32_CMPGEQS,          INS_FOP },
    { "cmpglts",        OPC32_CMPGLTS,          INS_FOP },
    { "cmpgles",        OPC32_CMPGLES,          INS_FOP },

    { "cvtdg",          OPC32_CVTDG,            INS_FP2 },
    { "cvtdgc",         OPC32_CVTDGC,           INS_FP2 },
    { "cvtdgu",         OPC32_CVTDGU,           INS_FP2 },
    { "cvtdguc",        OPC32_CVTDGUC,          INS_FP2 },
    { "cvtdgs",         OPC32_CVTDGS,           INS_FP2 },
    { "cvtdgsc",        OPC32_CVTDGSC,          INS_FP2 },
    { "cvtdgsu",        OPC32_CVTDGSU,          INS_FP2 },
    { "cvtdgsuc",       OPC32_CVTDGSUC,         INS_FP2 },

    { "cvtgd",          OPC32_CVTGD,            INS_FP2 },
    { "cvtgdc",         OPC32_CVTGDC,           INS_FP2 },
    { "cvtgdu",         OPC32_CVTGDU,           INS_FP2 },
    { "cvtgduc",        OPC32_CVTGDUC,          INS_FP2 },
    { "cvtgds",         OPC32_CVTGDS,           INS_FP2 },
    { "cvtgdsc",        OPC32_CVTGDSC,          INS_FP2 },
    { "cvtgdsu",        OPC32_CVTGDSU,          INS_FP2 },
    { "cvtgdsuc",       OPC32_CVTGDSUC,         INS_FP2 },

    { "cvtgf",          OPC32_CVTGF,            INS_FP2 },
    { "cvtgfc",         OPC32_CVTGFC,           INS_FP2 },
    { "cvtgfu",         OPC32_CVTGFU,           INS_FP2 },
    { "cvtgfuc",        OPC32_CVTGFUC,          INS_FP2 },
    { "cvtgfs",         OPC32_CVTGFS,           INS_FP2 },
    { "cvtgfsc",        OPC32_CVTGFSC,          INS_FP2 },
    { "cvtgfsu",        OPC32_CVTGFSU,          INS_FP2 },
    { "cvtgfsuc",       OPC32_CVTGFSUC,         INS_FP2 },

    { "cvtqf",          OPC32_CVTQF,            INS_FP2 },
    { "cvtqfc",         OPC32_CVTQFC,           INS_FP2 },
    { "cvtqfs",         OPC32_CVTQFS,           INS_FP2 },
    { "cvtqfsc",        OPC32_CVTQFSC,          INS_FP2 },
    { "cvtqg",          OPC32_CVTQG,            INS_FP2 },
    { "cvtqgc",         OPC32_CVTQGC,           INS_FP2 },
    { "cvtqgs",         OPC32_CVTQGS,           INS_FP2 },
    { "cvtqgsc",        OPC32_CVTQGSC,          INS_FP2 },

    { "divf",           OPC32_DIVF,             INS_FOP },
    { "divfc",          OPC32_DIVFC,            INS_FOP },
    { "divfu",          OPC32_DIVFU,            INS_FOP },
    { "divfuc",         OPC32_DIVFUC,           INS_FOP },
    { "divfs",          OPC32_DIVFS,            INS_FOP },
    { "divfsc",         OPC32_DIVFSC,           INS_FOP },
    { "divfsu",         OPC32_DIVFSU,           INS_FOP },
    { "divfsuc",        OPC32_DIVFSUC,          INS_FOP },
    { "divg",           OPC32_DIVG,             INS_FOP },
    { "divgc",          OPC32_DIVGC,            INS_FOP },
    { "divgu",          OPC32_DIVGU,            INS_FOP },
    { "divguc",         OPC32_DIVGUC,           INS_FOP },
    { "divgs",          OPC32_DIVGS,            INS_FOP },
    { "divgsc",         OPC32_DIVGSC,           INS_FOP },
    { "divgsu",         OPC32_DIVGSU,           INS_FOP },
    { "divgsuc",        OPC32_DIVGSUC,          INS_FOP },

    { "mulf",           OPC32_MULF,             INS_FOP },
    { "mulfc",          OPC32_MULFC,            INS_FOP },
    { "mulfu",          OPC32_MULFU,            INS_FOP },
    { "mulfuc",         OPC32_MULFUC,           INS_FOP },
    { "mulfs",          OPC32_MULFS,            INS_FOP },
    { "mulfsc",         OPC32_MULFSC,           INS_FOP },
    { "mulfsu",         OPC32_MULFSU,           INS_FOP },
    { "mulfsuc",        OPC32_MULFSUC,          INS_FOP },
    { "mulg",           OPC32_MULG,             INS_FOP },
    { "mulgc",          OPC32_MULGC,            INS_FOP },
    { "mulgu",          OPC32_MULGU,            INS_FOP },
    { "mulguc",         OPC32_MULGUC,           INS_FOP },
    { "mulgs",          OPC32_MULGS,            INS_FOP },
    { "mulgsc",         OPC32_MULGSC,           INS_FOP },
    { "mulgsu",         OPC32_MULGSU,           INS_FOP },
    { "mulgsuc",        OPC32_MULGSUC,          INS_FOP },

    { "subf",           OPC32_SUBF,             INS_FOP },
    { "subfc",          OPC32_SUBFC,            INS_FOP },
    { "subfu",          OPC32_SUBFU,            INS_FOP },
    { "subfuc",         OPC32_SUBFUC,           INS_FOP },
    { "subfs",          OPC32_SUBFS,            INS_FOP },
    { "subfsc",         OPC32_SUBFSC,           INS_FOP },
    { "subfsu",         OPC32_SUBFSU,           INS_FOP },
    { "subfsuc",        OPC32_SUBFSUC,          INS_FOP },
    { "subg",           OPC32_SUBG,             INS_FOP },
    { "subgc",          OPC32_SUBGC,            INS_FOP },
    { "subgu",          OPC32_SUBGU,            INS_FOP },
    { "subguc",         OPC32_SUBGUC,           INS_FOP },
    { "subgs",          OPC32_SUBGS,            INS_FOP },
    { "subgsc",         OPC32_SUBGSC,           INS_FOP },
    { "subgsu",         OPC32_SUBGSU,           INS_FOP },
    { "subgsuc",        OPC32_SUBGSUC,          INS_FOP },

    { "cvtgq",          OPC32_CVTGQ,            INS_FP2 },
    { "cvtgqc",         OPC32_CVTGQC,           INS_FP2 },
    { "cvtgqv",         OPC32_CVTGQV,           INS_FP2 },
    { "cvtgqvc",        OPC32_CVTGQVC,          INS_FP2 },
    { "cvtgqs",         OPC32_CVTGQS,           INS_FP2 },
    { "cvtgqsc",        OPC32_CVTGQSC,          INS_FP2 },
    { "cvtgqsv",        OPC32_CVTGQSV,          INS_FP2 },
    { "cvtgqsvc",       OPC32_CVTGQSVC,         INS_FP2 },

    { "sqrtf",          OPC32_SQRTF,            INS_FP2 },
    { "sqrtfc",         OPC32_SQRTFC,           INS_FP2 },
    { "sqrtfu",         OPC32_SQRTFU,           INS_FP2 },
    { "sqrtfuc",        OPC32_SQRTFUC,          INS_FP2 },
    { "sqrtfs",         OPC32_SQRTFS,           INS_FP2 },
    { "sqrtfsc",        OPC32_SQRTFSC,          INS_FP2 },
    { "sqrtfsu",        OPC32_SQRTFSU,          INS_FP2 },
    { "sqrtfsuc",       OPC32_SQRTFSUC,         INS_FP2 },
    { "sqrtg",          OPC32_SQRTG,            INS_FP2 },
    { "sqrtgc",         OPC32_SQRTGC,           INS_FP2 },
    { "sqrtgu",         OPC32_SQRTGU,           INS_FP2 },
    { "sqrtguc",        OPC32_SQRTGUC,          INS_FP2 },
    { "sqrtgs",         OPC32_SQRTGS,           INS_FP2 },
    { "sqrtgsc",        OPC32_SQRTGSC,          INS_FP2 },
    { "sqrtgsu",        OPC32_SQRTGSU,          INS_FP2 },
    { "sqrtgsuc",       OPC32_SQRTGSUC,         INS_FP2 },
    
    { "mb",             OPC32_MB,               INS_MIS },
    { "wmb",            OPC32_WMB,              INS_MIS },
    { "excb",           OPC32_EXCB,             INS_MIS },
    { "trapb",          OPC32_TRAPB,            INS_MIS },
    { "draint",         OPC32_TRAPB,            INS_MIS },

    { "rcc",            OPC32_RCC,              INS_RPCC },
    { "rpcc",           OPC32_RCC,              INS_RPCC },
    { "rc",             OPC32_RC,               INS_M1A },
    { "rs",             OPC32_RS,               INS_M1A },

    { "fetch",          OPC32_FETCH,            INS_M1B },
    { "fetch_m",        OPC32_FETCH_M,          INS_M1B },

    { "call_pal",       0x0,                    INS_CALLPAL },
    { "halt",           0x0,                    INS_MIS },

    { ".include",	NOT_USED,		INCLUDE },
    { ".include_dir",	NOT_USED,		INCLUDE_DIR },
    { ".minclude",	NOT_USED,		MINCLUDE },
    { ".if",		NOT_USED,		IF },
    { ".iif",		NOT_USED,		IIF },
    { ".repeat",	NOT_USED,		REPEAT },
#ifdef USE_WHILE /* NOTE: While's were shot down because we couldn't suppress the preprocess of the .while line when in a macro */ 
    { ".while",         NOT_USED,               WHILE },
#endif
    { ".break",         NOT_USED,               BREAK },
    { ".continue",      NOT_USED,               CONTINUE },
    { ".macro",		NOT_USED,		MACRO },
    { ".pragma",        NOT_USED,		PRAGMA },
    { ".next_argument", NOT_USED,               NEXT_ARG },
    { ".psect",		NOT_USED,		PSECT },
    { ".save_psect",	NOT_USED,		SAVE_PSECT },
    { ".save_dsect",	NOT_USED,		SAVE_DSECT },
    { ".save",		NOT_USED,		SAVE_PSECT },
    { ".restore_dsect",	NOT_USED,		RESTORE_DSECT },
    { ".restore_psect",	NOT_USED,		RESTORE_PSECT },
    { ".restore",	NOT_USED,		RESTORE_PSECT },
    { ".address",	NOT_USED,		ADDR },
    { ".addr",		NOT_USED,		ADDR },
    { ".architecture",  NOT_USED,               ARCH },
    { ".quad",		NOT_USED,		QUAD },
    { ".long",		NOT_USED,		LONG },
    { ".ascii",		NOT_USED,		ASCII },
    { ".asciz",		NOT_USED,		ASCIZ },
    { ".warn",		NOT_USED,		WARN },
    { ".error",		NOT_USED,		ERROR },
    { ".print",		NOT_USED,		PRINT },
    { ".blkl",		NOT_USED,		BLKL },
    { ".blkq",		NOT_USED,		BLKQ },
    { ".ident",		NOT_USED,		IDENT },
    { ".title",		NOT_USED,		TITLE },
    { ".align",		NOT_USED,		ALIGN },
    { ".list",		NOT_USED,		LIST },
    { ".show",		NOT_USED,		LIST },
    { ".nolist",	NOT_USED,		NOLIST },
    { ".nlist",	        NOT_USED,		NOLIST },
    { ".noshow",	NOT_USED,		NOLIST },
    { ".debug",		NOT_USED,		K_DEBUG },
    { ".nodebug",	NOT_USED,		NODEBUG },
    { ".end",		NOT_USED,		ENDP },
    { ".dsect",         NOT_USED,               DSECT },
    { ".link_address",  NOT_USED,               LINK_ADDRESS },
    { ".link_offset",   NOT_USED,               LINK_OFFSET },
    { ".link_first",    NOT_USED,               LINK_FIRST },
    { ".link_last",     NOT_USED,               LINK_LAST },
    { ".link_attribute", NOT_USED,              LINK_ATTR },
    { ".link_after",    NOT_USED,               LINK_AFTER },
    { ".link_region",   NOT_USED,               LINK_REGION },
    { ".link_size",     NOT_USED,               LINK_SIZE },
    { ".header",        NOT_USED,               HEADER },
    { ".endh",          NOT_USED,               ENDH },
    { ".cmd_input",     NOT_USED,               CMDIN },
    { ".do_cmd",        NOT_USED,               DOCMD },
    { ".endi",          NOT_USED,               ENDI },
};


#define NUM_EV4OPER	(sizeof(ev4_opcodes)/sizeof(ev4_opcodes[0]))
static DEFOPER ev4_opcodes[] = {
    { "hw_rei",         OPC32_EV4_HW_REI,           INS_MIS },
    { "hw_mfpr",        OPC32_EV4_HW_MFPR,          INS_IPR4 },
    { "hw_mtpr",        OPC32_EV4_HW_MTPR,          INS_IPR4 },
    { "hw_ldl",         OPC32_EV4_HW_LD,            INS_HWM4 },
    { "hw_ldlp",        (OPC32_EV4_HW_LD|(1<<15)),  INS_HWM4 },
    { "hw_ldla",        (OPC32_EV4_HW_LD|(1<<14)),  INS_HWM4 },
    { "hw_ldlr",        (OPC32_EV4_HW_LD|(1<<13)),  INS_HWM4 },
    { "hw_ldlpa",       (OPC32_EV4_HW_LD|(3<<14)),  INS_HWM4 },
    { "hw_ldlpr",       (OPC32_EV4_HW_LD|(5<<13)),  INS_HWM4 },
    { "hw_ldlar",       (OPC32_EV4_HW_LD|(3<<13)),  INS_HWM4 },
    { "hw_ldlpar",      (OPC32_EV4_HW_LD|(7<<13)),  INS_HWM4 },
    { "hw_ldq",         (OPC32_EV4_HW_LD|(1<<12)),  INS_HWM4 },
    { "hw_ldqp",        (OPC32_EV4_HW_LD|(9<<12)),  INS_HWM4 },
    { "hw_ldqa",        (OPC32_EV4_HW_LD|(5<<12)),  INS_HWM4 },
    { "hw_ldqr",        (OPC32_EV4_HW_LD|(3<<12)),  INS_HWM4 },
    { "hw_ldqpa",       (OPC32_EV4_HW_LD|(13<<12)), INS_HWM4 },
    { "hw_ldqpr",       (OPC32_EV4_HW_LD|(11<<12)), INS_HWM4 },
    { "hw_ldqar",       (OPC32_EV4_HW_LD|(7<<12)),  INS_HWM4 },
    { "hw_ldqpar",      (OPC32_EV4_HW_LD|(15<<12)), INS_HWM4 },
    { "hw_stl",         OPC32_EV4_HW_ST,            INS_HWM4 },
    { "hw_stlp",        (OPC32_EV4_HW_ST|(1<<15)),  INS_HWM4 },
    { "hw_stla",        (OPC32_EV4_HW_ST|(1<<14)),  INS_HWM4 },
    { "hw_stlr",        (OPC32_EV4_HW_ST|(1<<13)),  INS_HWM4 },
    { "hw_stlpa",       (OPC32_EV4_HW_ST|(3<<14)),  INS_HWM4 },
    { "hw_stlpr",       (OPC32_EV4_HW_ST|(5<<13)),  INS_HWM4 },
    { "hw_stlar",       (OPC32_EV4_HW_ST|(3<<13)),  INS_HWM4 },
    { "hw_stlpar",      (OPC32_EV4_HW_ST|(7<<13)),  INS_HWM4 },
    { "hw_stq",         (OPC32_EV4_HW_ST|(1<<12)),  INS_HWM4 },
    { "hw_stqp",        (OPC32_EV4_HW_ST|(9<<12)),  INS_HWM4 },
    { "hw_stqa",        (OPC32_EV4_HW_ST|(5<<12)),  INS_HWM4 },
    { "hw_stqr",        (OPC32_EV4_HW_ST|(3<<12)),  INS_HWM4 },
    { "hw_stqpa",       (OPC32_EV4_HW_ST|(13<<12)), INS_HWM4 },
    { "hw_stqpr",       (OPC32_EV4_HW_ST|(11<<12)), INS_HWM4 },
    { "hw_stqar",       (OPC32_EV4_HW_ST|(7<<12)),  INS_HWM4 },
    { "hw_stqpar",      (OPC32_EV4_HW_ST|(15<<12)), INS_HWM4 },
};

/*NOTE: The ev5 opcodes below are the original PAL OPCODES in HAL before it was broken up to chip type */
#define NUM_EV5OPER	(sizeof(ev5_opcodes)/sizeof(ev5_opcodes[0]))
static DEFOPER ev5_opcodes[] = {
    { "hw_rei",         OPC32_EV5_HW_REI,           INS_MIS },
    { "hw_rei_stall",   (OPC32_EV5_HW_REI|(1<<14)), INS_MIS },
    { "hw_mfpr",        OPC32_EV5_HW_MFPR,          INS_IPR5 },
    { "hw_mtpr",        OPC32_EV5_HW_MTPR,          INS_IPR5 },
    { "hw_ld",          OPC32_EV5_HW_LD,            INS_HWM5 },
    { "hw_st",          OPC32_EV5_HW_ST,            INS_HWM5 },

/* These are only here to maintain backward compatablity to old EV5 code */
    { "mt",             OPC32_EV5_HW_MTPR,          INS_IPR5 },
    { "mf",             OPC32_EV5_HW_MFPR,          INS_IPR5 },
    { "ldlp",           (OPC32_EV5_HW_LD|(1<<15)),  INS_HWM5 }, 
    { "ldla",           (OPC32_EV5_HW_LD|(1<<14)),  INS_HWM5 },
    { "ldlw",           (OPC32_EV5_HW_LD|(1<<13)),  INS_HWM5 },
    { "ldlaw",          (OPC32_EV5_HW_LD|(3<<13)),  INS_HWM5 },
    { "ldlpl",          (OPC32_EV5_HW_LD|(33<10)),  INS_HWM5 },
    { "ldlv",           OPC32_EV5_HW_LD,            INS_HWM5 }, /* Isn't this wrong? */
    { "ldqp",           (OPC32_EV5_HW_LD|(9<<12)),  INS_HWM5 },
    { "ldqa",           (OPC32_EV5_HW_LD|(5<<12)),  INS_HWM5 },
    { "ldqw",           (OPC32_EV5_HW_LD|(3<<12)),  INS_HWM5 },
    { "ldqaw",          (OPC32_EV5_HW_LD|(7<<12)),  INS_HWM5 },
    { "ldqpl",          (OPC32_EV5_HW_LD|(37<<12)), INS_HWM5 },
    { "ldqv",           (OPC32_EV5_HW_LD|(1<<12)),  INS_HWM5 },
    { "stlp",           (OPC32_EV5_HW_ST|(1<<15)),  INS_HWM5 },
    { "stla",           (OPC32_EV5_HW_ST|(1<<14)),  INS_HWM5 },
    { "stlpc",          (OPC32_EV5_HW_ST|(33<<10)), INS_HWM5 },
    { "stlv",           OPC32_EV5_HW_ST,            INS_HWM5 }, /* Isn't this wrong? */
    { "stqp",           (OPC32_EV5_HW_ST|(9<<12)),  INS_HWM5 },
    { "stqa",           (OPC32_EV5_HW_ST|(5<<12)),  INS_HWM5 },
    { "stqpc",          (OPC32_EV5_HW_ST|(37<<12)), INS_HWM5 },
    { "stqv",           (OPC32_EV5_HW_ST|(1<<12)),  INS_HWM5 },
};

#define NUM_EV6OPER	(sizeof(ev6_opcodes)/sizeof(ev6_opcodes[0]))
static DEFOPER ev6_opcodes[] = {
    { "hw_jmp",         OPC32_EV6_HW_RET,           INS_REI6 },
    { "hw_jmp_stall",   (OPC32_EV6_HW_RET|(1<<13)), INS_REI6 },
    { "hw_jsr",         (OPC32_EV6_HW_RET|(2<<13)), INS_REI6 },
    { "hw_jsr_stall",   (OPC32_EV6_HW_RET|(3<<13)), INS_REI6 },
    { "hw_ret",         (OPC32_EV6_HW_RET|(4<<13)), INS_REI6 },
    { "hw_ret_stall",   (OPC32_EV6_HW_RET|(5<<13)), INS_REI6 },
    { "hw_jcr",         (OPC32_EV6_HW_RET|(6<<13)), INS_REI6 },
    { "hw_jcr_stall",   (OPC32_EV6_HW_RET|(7<<13)), INS_REI6 },
    { "hw_mfpr",        OPC32_EV6_HW_MFPR,          INS_MFI6 },
    { "hw_mtpr",        OPC32_EV6_HW_MTPR,          INS_MTI6 },
    { "hw_ldlp",        OPC32_EV6_HW_LD,            INS_HWM6 },
    { "hw_ldlpl",       (OPC32_EV6_HW_LD|(1<<13)),  INS_HWM6 },
    { "hw_ldlv",        (OPC32_EV6_HW_LD|(2<<13)),  INS_HWM6 },
    { "hw_ldl",         (OPC32_EV6_HW_LD|(4<<13)),  INS_HWM6 },
    { "hw_ldlw",        (OPC32_EV6_HW_LD|(5<<13)),  INS_HWM6 },
    { "hw_ldla",        (OPC32_EV6_HW_LD|(6<<13)),  INS_HWM6 },
    { "hw_ldlwa",       (OPC32_EV6_HW_LD|(7<<13)),  INS_HWM6 },
    { "hw_ldqp",        (OPC32_EV6_HW_LD|(1<<12)),  INS_HWM6 },
    { "hw_ldqpl",       (OPC32_EV6_HW_LD|(3<<12)),  INS_HWM6 },
    { "hw_ldqv",        (OPC32_EV6_HW_LD|(5<<12)),  INS_HWM6 },
    { "hw_ldq",         (OPC32_EV6_HW_LD|(9<<12)),  INS_HWM6 },
    { "hw_ldqw",        (OPC32_EV6_HW_LD|(11<<12)), INS_HWM6 },
    { "hw_ldqa",        (OPC32_EV6_HW_LD|(13<<12)), INS_HWM6 },
    { "hw_ldqwa",       (OPC32_EV6_HW_LD|(15<<12)), INS_HWM6 },
    { "hw_stlp",        OPC32_EV6_HW_ST,            INS_HWM6 },
    { "hw_stlpc",       (OPC32_EV6_HW_ST|(1<<13)),  INS_HWM6 },
    { "hw_stl",         (OPC32_EV6_HW_ST|(2<<13)),  INS_HWM6 },
    { "hw_stla",        (OPC32_EV6_HW_ST|(6<<13)),  INS_HWM6 },
    { "hw_stqp",        (OPC32_EV6_HW_ST|(1<<12)),  INS_HWM6 },
    { "hw_stqpc",       (OPC32_EV6_HW_ST|(3<<12)),  INS_HWM6 },
    { "hw_stq",         (OPC32_EV6_HW_ST|(5<<12)),  INS_HWM6 },
    { "hw_stqa",        (OPC32_EV6_HW_ST|(13<<12)), INS_HWM6 },
};


