C	SPACE SIMULATION PROGRAM
C
C	WRITTEN BY MICHAEL LAMPI  3-NOV-78
C
	COMMON/DFILE/IBUF(6400)
	COMMON IOBJSZ(3),OBJCTX(3),OBJCTY(3),OBJVX(3),OBJVY(3)
	COMMON STARX(60),STARY(60),STARDX(60),STARDY(60)
	COMMON ISHPRY(3),IOFFLG(3),SHIPX(3),SHIPY(3),ISHPSZ(3)
	COMMON SHIPVX(3),SHIPVY(3)
	COMMON SHPRYX(3),SHPRYY(3),SHPRVX(3),SHPRVY(3)
	COMMON IRAYDS(8),IRAYX(9)
	COMMON IOBJCT,ISTARL,ISTARS,ILENG,IRAYSP,RAYSPD,ISHIPS,ISHPHF
	COMMON ISHPTP(3),ISHPNO,IWAIT,PIRAD,IBELL
	LOGICAL*1 IBELL
	DATA IBELL/7/
	DATA IOBJCT/3/
	DATA ISTARS/60/
	DATA ILENG/121/
	DATA SHIPVX,SHIPVY/6*0.0/
	DATA SHIPX,SHIPY/6*0.0/,ISHPSZ/3*0/
	DATA IRAYSP/8/,RAYSPD/8.0/
	DATA ISHIPS/10/,ISHPHF/5/
	DATA ISHPNO/3/
	DATA IWAIT/1000/
	DATA PIRAD/.31415926/
	DATA IRAYX/0,150,280,370,420,450,475,495,511/
C
C	CHECK IF A DISPLAY FILE ALREADY DEFINED ON THIS DISC
	CALL FILCHK(IER)
C
C	IF SO, DON'T REDEFINE IT
	IF(IER.NE.0) GOTO 8
	DO 4 I=1,IOBJCT
 4	CALL POINTR(21-I,696+I*4)
	GOTO 1
C
C	NO DISPLAY FILE ON DISC - DEFINE ONE
 8	CALL INITWR
	CALL INTWR2
	CALL INITW1
	ISTARL=ISTARL-1
C		AND SAVE IT ON DISK
C	CALL FILSAV
C
C	RESTART - RESET VALUES
 1	ISCORE=0
C	INITIALIZE SCORE AND NUMBER OF CRASHES
	CALL POINTR(6,310,3)
	CALL FLASH(6,-1)
	CALL IDIGIT(0)
	CALL ADVANC(6,6)
	CALL I3DIG(0)
C	INITIALIZE CRASH DELAY COUNTER
C	INITIALIZE HIT COUNTER
	IHIT=0
	CALL ADVANC(6,3)
	CALL I3DIG(0)
C	INITIALIZE SHIPS HIT COUNTER
	CALL ADVANC(6,3)
	CALL I3DIG(0)
	ISHPHT=0
	ICRFLG=0
	ICRASH=0
	IOVTIM=1
	LTIME=0
	ICNT=0
	IRAY=0
	XFRAME=511.
	YFRAME=511.
	CALL OFF(500)
C
C	TURN OFF RAYS
	DO 7 I=1,IRAYSP
	CALL OFF(300+I)
7	IRAYDS(I)=0
C
C	TURN OFF METEOR-LIKE OBJECTS
	DO 5 I=700,699+IOBJCT*4,4
	CALL OFF(I+1)
	CALL OFF(I+2)
5	CALL OFF(I+3)
	DO 6 I=1,IOBJCT
6	IOBJSZ(I)=0
C
C	TURN OFF GAME OVER MESSAGE
	CALL OFF(400)
C
C	INITIALIZE SHIPS
	DO 2 I=1,ISHPNO
	ISHPTP(I)=0
	ISHPRY(I)=0
	IOFFLG(I)=0
2	ISHPSZ(I)=0
C
C	TURN OFF ALL SHIP IMAGES
	J=ISHIPS*4
	DO 3 I=1,J
	CALL OFF(I)
3	CONTINUE
C
C	TURN OFF RAY
	CALL OFF(301)
C
C	TURN OFF EXPLOSION
	CALL OFF(600)
C
C	RESET CLOCK
	STIME=SECNDS(0.)
C
C	NOW FOR THE PROGRAM LOGIC
C
150	ETIME=SECNDS(STIME)
	ITIME=ILENG-INT(ETIME)
	IF(LTIME.EQ.ETIME) GOTO 1505
	CALL POINTR(6,310,6)
	CALL I3DIG(ITIME)
	LTIME=ITIME
C
C	CHECK FOR END OF GAME
	IF(ITIME.EQ.0) GOTO 900
1505	CONTINUE
C
C	SEE IF CRASH FLAG IS ON
	IF(ICRFLG.EQ.0) GOTO 1500
	ICRFLG=ICRFLG-1
	IF(ICRFLG.EQ.0) CALL OFF(500)
C
C	SEE IF WE SHOULD START MOVING A SHIP
C
1500	IF(RAN(IRX,IRY).LT.0.92) GOTO 151
C	YES - SEE IF THERE IS A SHIP TO START
	DO 1501 I=1,ISHPNO
	IF(ISHPSZ(I).EQ.0) GOTO 1503
1501	CONTINUE
C	NO SHIPS NOT MOVING - CONTINUE ON
	GOTO 151
1503	DO 1504 J=1,ISHPNO
	IF(J.EQ.I) GOTO 1504
	IF(ISHPSZ(J).EQ.1) GOTO 151
1504	CONTINUE
C	THERE IS A FREE SPOT - START A SHIP MOVING
	ISHPSZ(I)=1
C	SEE IF WE SHOULD START A SHIP OF TYPE 2
	IF(RAN(IRX,IRY).LT..9) GOTO 1508
	ISHPTP(I)=ISHIPS*2+1
	GOTO 1506
1508	ISHPTP(I)=1
1506	SHIPX(I)=1023.0*(.5-RAN(IRX,IRY))+XFRAME
	SHIPY(I)=1023.0*(.5-RAN(IRX,IRY))+YFRAME
	SHIPVY(I)=(0.5-RAN(IRX,IRY))*100.
	SHIPVX(I)=(0.5-RAN(IRX,IRY))*100.
	CALL POINTR(I,ISHPTP(I))
	CALL CHANGE(I,SHIPX(I)-XFRAME+511.0,SHIPY(I)-YFRAME+511.0)
	CALL ON(ISHPTP(I))
C
C	NOW MOVE THE SHIPS
C
151	DO 1531 I=1,ISHPNO
	ISIZE=ISHPSZ(I)
	IF(ISIZE.EQ.0) GOTO 1531
C
C	MODIFY SHIP VELOCITY AT RANDOM
	IF(RAN(IRX,IRY).LT.95) GOTO 1515
	IF(RAN(IRX,IRY).LT.0.5) GOTO 1512
	SHIPVX(I)=SHIPVX(I)+(0.5-RAN(IRX,IRY))*10.
	GOTO 1515
1512	SHIPVY(I)=SHIPVY(I)+(0.5-RAN(IRX,IRY))*10.
1515	SHIPX(I)=SHIPVX(I)/FLOAT(ISHIPS+1-ISHPSZ(I))+SHIPX(I)
	SHIPY(I)=SHIPVY(I)/FLOAT(ISHIPS+1-ISHPSZ(I))+SHIPY(I)
	IF(SHIPX(I).LT.XFRAME-511..OR.SHIPX(I).GT.XFRAME+511.) GOTO 152
	IF(SHIPY(I).GE.YFRAME-511..AND.SHIPY(I).LE.YFRAME+390.) GOTO 155
C
C	SHIP HIT EDGE OF SCREEN - REMOVE IT FROM SIGHT
152	IF(IOFFLG(I).EQ.0) CALL OFF(ISHPTP(I))
	IF(ISIZE.GT.ISHPHF) GOTO 153
C	ALLOW SHIP TO GO OFF EDGE
	IF(SHIPX(I).LT.XFRAME-1023..OR.SHIPX(I).GT.XFRAME+1023.)
     C		GOTO 153
	IF(SHIPY(I).LT.YFRAME-1023..OR.SHIPY(I).GT.YFRAME+1023.)
     C		GOTO 153
	IOFFLG(I)=1
	ISHPRY(I)=0
	CALL OFF(ISHPTP(I)+1)
	GOTO 15509
C
C	SHIP HIT EDGE - REMOVE IT
153	ISHPSZ(I)=0
	IOFFLG(I)=0
	CALL OFF(ISHPTP(I))
	CALL OFF(ISHPTP(I)+1)
	ISHPRY(I)=0
	GOTO 1531
C
C	SEE IF WE SHOULD TURN ON THIS SHIP RETURNING FROM EDGE
155	IF(IOFFLG(I).EQ.0) GOTO 15503
	IOFFLG(I)=0
	CALL ON(ISHPTP(I))
C
C	SEE IF THE SHIP IS GOING TO FIRE IT'S RAY GUN
15503	IF(ISHPRY(I).NE.0) GOTO 15506
	IF(ISIZE.LT.ISHPHF-2) GOTO 15509
	IF(RAN(IRX,IRY).LT.0.92) GOTO 15509
	CALL POINTR(12+I,ISHPTP(I)+1)
	ISHPRY(I)=7
C	AIM FOR THE BOTTOM CENTER OF SCREEN TO APPEAR AS THOUGH
C	WE'RE HITTING THE USER
	SHPRVX(I)=SIGN(RAN(IRX,IRY),XFRAME-SHIPX(I))*100.
	SHPRVY(I)=RAN(IRX,IRY)*.25*(0.-ABS(SHIPY(I)-YFRAME+511.))
	SHPRYX(I)=(0.5-RAN(IRX,IRY))*20.
	SHPRYY(I)=(0.5-RAN(IRX,IRY))*20.
	CALL CHANGE(12+I,SHPRYX(I),SHPRYY(I))
	CALL ON(ISHPTP(I)+1)
	GOTO 15509
C
C	EXTEND SHIP'S RAYS
15506	ISHPRY(I)=ISHPRY(I)-1
	SHPRYX(I)=SHPRYX(I)+SHPRVX(I)
	SHPRYY(I)=SHPRYY(I)+SHPRVY(I)
	CALL CHANGE(12+I,SHPRYX(I),SHPRYY(I))
	IF(SHIPX(I)+SHPRYX(I)-256..GT.XFRAME
     C		.OR.SHIPX(I)+SHPRYX(I)+256..LT.XFRAME) GOTO 15507
	IF(SHIPY(I)+SHPRYY(I)+511..GT.YFRAME) GOTO 15507
C
C	FIGURE WE GOT A HIT ON THE USER
	CALL HIT(ISCORE,IHIT,ICRFLG)
	ISHPRY(I)=0
C
C	TURN OFF SHIP'S RAYS
15507	IF(ISHPRY(I).EQ.0) CALL OFF(ISHPTP(I)+1)
C
C	SEE IF WE SHOULD INCREASE SHIP'S SIZE
15509	IF(RAN(IRX,IRY).LT.0.96) GOTO 170
C
C	YES - CHECK IF SHIP ALREADY AT LIMIT
	IF(ISIZE.LT.ISHIPS.OR.IOFFLG(I).EQ.1) GOTO 1555
C
C	SHIP IS ALREADY AT MAX SIZE - ASSUME A CRASH
	CALL CRASH(ISCORE,ICRASH,ICRFLG,0)
	GOTO 153
C
C	CHECK IF OTHER SHIP HAS THIS SAME SIZE
1555	DO 156 J=1,ISHPNO
	IF(J.EQ.I) GOTO 156
	IF(ISHPSZ(J).EQ.ISIZE+1) GOTO 170
156	CONTINUE
	CALL OFF(ISHPTP(I))
	CALL OFF(ISHPTP(I)+1)
	ISHPTP(I)=ISHPTP(I)+2
	ISHPSZ(I)=ISIZE+1
	CALL POINTR(I,ISHPTP(I))
	CALL CHANGE(I,SHIPX(I)-XFRAME+511.0,SHIPY(I)-YFRAME+511.0)
	IF(IOFFLG(I).EQ.0) CALL ON(ISHPTP(I))
	GOTO 1531
C
C	  REPOSITION THE SHIP
 170	CALL CHANGE(I,SHIPX(I)-XFRAME+511.0,SHIPY(I)-YFRAME+511.0)
 1531	CONTINUE
C
C	  CHECK THE JOYSTICK
C
 180	CALL JOYSTK(IX,IY,IBUT)
	XSPEED=FLOAT(IX-511)/150.
	YSPEED=FLOAT(511-IY)/150.
	XSPEED=EXP(ABS(XSPEED))*SIGN(1.,XSPEED)
	YSPEED=EXP(ABS(YSPEED))*SIGN(1.,YSPEED)
	XFRAME=XSPEED+XFRAME
	YFRAME=YSPEED+YFRAME
	K=0
	IF(ABS(XSPEED).GT.7.0.OR.ABS(YSPEED).GT.7.0) K=1
C
C	  NOW CALCULATE THE NEW STAR BACKGROUND POSITION
	DO 18095 J=1,ISTARS
	STARX(J)=STARX(J)+STARDX(J)-XSPEED
	STARY(J)=STARY(J)+STARDY(J)-YSPEED
	IXPOS=IFIX(STARX(J))
	IYPOS=IFIX(STARY(J))
C	  BYPASS CHECKING FOR PROPER DIRECTION IF SPEED TOO HIGH
	IF(K.NE.0) GOTO 1807
	IF(IXPOS.GT.511) GOTO 1804
	IF(STARDX(J).GT.0.) STARDX(J)=-STARDX(J)
	GOTO 1805
 1804	IF(STARDX(J).LT.0.) STARDX(J)=-STARDX(J)
 1805	IF(IYPOS.GT.511) GOTO 1806
	IF(STARDY(J).GT.0.) STARDY(J)=-STARDY(J)
	GOTO 1807
 1806	IF(STARDY(J).LT.0.) STARDY(J)=-STARDY(J)
 1807	IF(IXPOS.GE.15) GOTO 1803
	GOTO 18022
C
18020	IXPOS=511
	IYPOS=511
	STARY(J)=511.
	STARX(J)=511.
	GOTO 1809
18021	IF(K.EQ.0) GOTO 18020
	IXPOS=15
	STARX(J)=15.
	GOTO 18035
18022	IF(K.EQ.0) GOTO 18020
	IXPOS=1005
	STARX(J)=1005.
	GOTO 18035
18023	IF(K.EQ.0) GOTO 18020
	IYPOS=15
	STARY(J)=15.
	GOTO 1809
18024	IF(K.EQ.0) GOTO 18020
	IYPOS=890
	STARY(J)=890.
	GOTO 1809
 1803	IF(IXPOS.GT.1005) GOTO 18021
18035	IF(IYPOS.LT.15) GOTO 18024
	IF(IYPOS.GT.900) GOTO 18023
C
C	  NOW ACTUALLY MOVE THE STAR BACKGROUND
 1809	IBUF(ISTARL+J*3-1)=IXPOS+"40000
	IBUF(ISTARL+J*3)=IYPOS
18095	CONTINUE
C
C	TURN OFF RAY IF NO COUNT LEFT
C
	IF(IEXPLO.EQ.0) GOTO 1800
	IEXPLO=IEXPLO-1
	IF(IEXPLO.EQ.0) CALL OFF(600)
C
C	CHECK IF THE RAY IS BEING FIRED
1800	IF(IRAYDS(IRAYSP).NE.1.AND.IRAYDS(IRAYSP-1).NE.1) GOTO 185
C
C	CHECK FOR A HIT
	DO 181 I=1,ISHPNO
	SHPSIZ=FLOAT(ISHPSZ(I)*ISHPSZ(I)*2)
	IF(SHIPX(I).LT.XFRAME-SHPSIZ) GOTO 181
	IF(SHIPX(I).GT.XFRAME+SHPSIZ) GOTO 181
	IF(SHIPY(I).LT.YFRAME-SHPSIZ) GOTO 181
	IF(SHIPY(I).GT.YFRAME+SHPSIZ) GOTO 181
C
C	HE'S HIT A SHIP - NOW EXPLODE IT
	CALL OFF(ISHPTP(I))
C	TURN OFF SHIP'S RAYS
	CALL OFF(ISHPTP(I)+1)
	ISHPRY(I)=0
C
C	RING THE BELL
	WRITE(5,1801) IBELL
1801	FORMAT($,1X,20A1)
C	INCREASE SCORE
	ISCORE=ISCORE+10*(ISHIPS-ISHPSZ(I)+1)
C	CHECK FOR SPECIAL SHIP TYPES
	IF(ISHPTP(I).GT.ISHIPS+ISHIPS) ISCORE=ISCORE+100
	CALL POINTR(6,310,3)
	CALL IDIGIT(ISCORE)
	ISHPSZ(I)=0
C	TURN ON EXPLOSION
	CALL ON(600)
	IEXPLO=5
C	CHANGE SHIP HIT COUNTER
	ISHPHT=ISHPHT+1
	CALL ADVANC(6,12)
	CALL I3DIG(ISHPHT)
	GOTO 185
181	CONTINUE
C
C	SEE IF HE WANTS TO FIRE THE RAY GUN
C
185	IF(IBUT.EQ.1) IRAY=2
190	IF(IRAY.EQ.0) GOTO 200
	DO 195 I=IRAYSP,1,-1
	IF(IRAYDS(I).EQ.0) GOTO 195
	IF(I.NE.IRAYSP) GOTO 191
	IF(IRAY.NE.2) IRAY=0
	IRAYDS(I)=0
	CALL OFF(300+I)
	GOTO 195
191	IRAYDS(I+1)=1
	IF(IRAY.NE.2) IRAY=1
	CALL OFF(300+I)
	CALL ON(301+I)
	IRAYDS(I)=0
195	CONTINUE
	IF(IRAY.NE.2) GOTO 200
	IRAYDS(1)=1
	IRAY=1
	CALL ON(301)
C
C	NOW TURN ON METEOR-LIKE OBJECTS
200	DO 210 I=1,IOBJCT
	IF(IOBJSZ(I).NE.0) GOTO 205
C	SEE IF WE SHOULD START THIS OBJECT MOVING
	IF(RAN(IRX,IRY).LT.0.85) GOTO 210
	IOBJSZ(I)=1
	OBJVX(I)=(RAN(IRX,IRY)-0.5)*50.
	OBJVY(I)=(RAN(IRX,IRY)-0.5)*50.
	OBJCTX(I)=XFRAME+OBJVX(I)+511.
	OBJCTY(I)=YFRAME+OBJVY(I)+511.
	CALL CHANGE(21-I,OBJCTX(I)-XFRAME,OBJCTY(I)-YFRAME)
	CALL ON(696+I*4)
	GOTO 210
205	OBJCTX(I)=OBJCTX(I)+OBJVX(I)/FLOAT(5-IOBJSZ(I))
	OBJCTY(I)=OBJCTY(I)+OBJVY(I)/FLOAT(5-IOBJSZ(I))
	IF(OBJCTX(I).LT.XFRAME.OR.OBJCTX(I).GT.XFRAME+1023.)
     C		GOTO 207
	IF(OBJCTY(I).LT.YFRAME.OR.OBJCTY(I).GT.YFRAME+900.)
     C		GOTO 207
	CALL CHANGE(21-I,OBJCTX(I)-XFRAME,OBJCTY(I)-YFRAME)
C
C	SEE IF HE HIT THE METEOR WITH THE RAY GUN
	IF(IRAY.EQ.0) GOTO 2050
C	ONLY ALLOW A HIT IF NEAR CROSSHAIRS
	IF(IRAYDS(IRAYSP).NE.1.AND.IRAYDS(IRAYSP-1).NE.1) GOTO 2050
	ISIZE=IOBJSZ(I)
	SIZE=FLOAT(ISIZE*ISIZE*ISIZE)
	IF(OBJCTX(I)-511..LT.XFRAME-SIZE
     C		.OR.OBJCTX(I)-511..GT.XFRAME+SIZE) GOTO 2050
	IF(OBJCTY(I)-511..LT.YFRAME-SIZE
     C		.OR.OBJCTY(I)-511..GT.YFRAME+SIZE) GOTO 2050
C	HE'S HIT THE METEOR - EXPLODE IT
	CALL ON(600)
	IEXPLO=5
	GOTO 207
2050	IF(RAN(IRX,IRY).LT.0.99) GOTO 210
C
C	SEE IF WE SHOULD INCREASE APPARENT SIZE OF METEOR
	IF(IOBJSZ(I).EQ.4) GOTO 206
	IOBJSZ(I)=IOBJSZ(I)+1
	CALL ON(695+I*4+IOBJSZ(I))
	GOTO 210
C
C	METEOR ALREADY AT MAXIMUM SIZE - ASSUME A CRASH
206	CALL CRASH(ISCORE,ICRASH,ICRFLG,1)
C	TURN OFF OBJECT
207	J=I*4
	CALL OFF(696+J)
	CALL OFF(697+J)
	CALL OFF(698+J)
	CALL OFF(699+J)
	IOBJSZ(I)=0
	GOTO 210
210	CONTINUE
	GOTO 150
C
C	END OF GAME
900	IF(ISCORE.GT.300*IOVTIM) GOTO 930
	CALL ON(400)
	WRITE(5,910)
910	FORMAT($,' HIT RETURN IF YOU WISH TO RESTART')
	READ(5,920) IRESP
920	FORMAT(A1)
	IF(IRESP.EQ.'') GOTO 1
	STOP
C
C	HE'S GONE INTO OVERTIME
930	CALL ON(540)
	CALL POINTR(6,310,3)
	CALL FLASH(6,1)
C	DELAY A BIT
	DO 940 I=1,IWAIT
	STIME=SECNDS(0.)
940	CONTINUE
	CALL OFF(540)
	IOVTIM=IOVTIM+1
	GOTO 150
	END

 