C	PROGRAM TO DUMP CONTENTS OF A DISPLAY FILE
C	WRITTEN BY MICHAEL LAMPI   WINTER 1978-9
C
	COMMON/DFILE/ IBUF(10000)
	COMMON/PLOTTR/LASTX,LASTY
	DIMENSION INSTR(13)
	LOGICAL*1 ILINE(64),ICHR(2),FNAME(16),VTINST(65)
	INTEGER TSCAL(9)
	INTEGER PLTON(3),PLTOFF(3),PLTRST(3),PLTPON(3),PLTPOF(3)
	INTEGER PLTGIN(3),PLTPAD,OINSTR,US,GS,BELL
	INTEGER TWIDTH,ICHAR
	EQUIVALENCE (ICHAR,ICHR(1))
	DATA VTINST/'D','H','A','L','T',
     C		'D','J','S','R',' ',
     C		'D','J','M','P','A',
     C		'D','N','O','P',' ',
     C		'L',' ','S','R','A',
     C		'L',' ','S','R','B',
     C		'X','G','R','A',' ',
     C		'Y','G','R','A',' ',
     C		'L','V','E','C','T',
     C		'S','V','E','C','T',
     C		'T','E','X','T',' ',
     C		'A','P','N','T',' ',
     C		'R','P','N','T',' ',/
C
	DATA INSTR/"173400,"162000,"160000,"164000,"170000,
     C		   "174000,"120000,"124000,"110000,"104000,
     C		   "100000,"114000,"130000/
C
C	PLOTTER CONTROL CHARACTERS
	DATA PLTON/"33,'A','E'/, PLTOFF/"33,'A','F'/
	DATA PLTRST/"33,'A','N'/, PLTPON/"33,'A','K'/
	DATA PLTPOF/"33,'A','L'/, PLTGIN/"33,'A','M'/
	DATA PLTPAD/"200/,US/'_'/,GS/"35/,BELL/"7/
	DATA TSCAL/"33,'A','I','5','6',' ','7','8',"177/
	DATA TWIDTH/14/
C
	WRITE(5,1111)
 1111	FORMAT(' DFILE Dumping Utility')
 11	WRITE(5,1)
 1	FORMAT($,' Enter display file name:')
	READ(5,2) LEN,(FNAME(I),I=1,LEN)
 2	FORMAT(Q,16A1)
	IF(LEN.EQ.0) GOTO 11
C	  FIRST CHECK IF FILE IS THERE
	OPEN(UNIT=7,NAME=FNAME,TYPE='OLD',READONLY,ERR=222)
C	  IF IT GETS HERE, FILE MUST BE THERE
	CLOSE(UNIT=7)
	GOTO 223
 222	WRITE(5,224)
 224	FORMAT(' ***ERROR: File not found***')
	GOTO 11
C	  NOW READ IN THE DISPLAY FILE
 223	CALL RSTR(FNAME)
	WRITE(5,3)
	IMODE=0
 3	FORMAT($,' Enter mode: (D=Dump, P=Plot): ')
	READ(5,4) IRESP
 4	FORMAT(A1)
	IF(IRESP.EQ.'P') IMODE=1
C	SEE HOW MUCH OF DISPLAY FILE REALLY USED
	DO 5 IEND=1,9999
	IF(IBUF(IEND).EQ.-1) GOTO 6
 5	CONTINUE
	STOP 'Display file is empty'
C
 6	IEND=IEND-1
	WRITE(5,7) IEND
 7	FORMAT(' Upper limit of display file is: ',O6//,
     C	       ' Enter starting location for dump/plot in O6 format:',$)
	READ(5,8) ISTART
 8	FORMAT(O6)
C
	IF(IMODE.NE.0) GOTO 110
C
C	DUMP MODE
C
	DO 100 J=ISTART,IEND,8
	WRITE(5,10) J,(IBUF(J+K),K=1,8)
	DO 80 K=1,8
C	SEE IF WE HAVE ANY DISPLAY PROCESSOR INSTRUCTIONS
	DO 30 L=1,13
	IVAL=IBUF(J+K)
	IF(L.LT.5) GOTO 25
	IVAL=IVAL.AND."174000
 25	IF(INSTR(L).EQ.IVAL) GOTO 50
 30	CONTINUE
C	  IF LAST INSTRUCTION WASN'T "TEXT", THEN BYPASS CHAR TRANSLATE
C	   ALSO BYPASS IF INSTRUCTION IS "LSRA"
	IF(OINSTR.NE.11.AND.OINSTR.NE.5) GOTO 45
C	CLEAR OUT THIS ENTRY
	DO 40 L=1,5
	ILINE((K-1)*5+L)="40
 40	CONTINUE
C	  THIS IS A CHARACTER, PRINT IT OUT
	ICHAR=IBUF(J+K)
	IF(ICHR(1).LT."40) ICHR(1)="40
	IF(ICHR(2).LT."40) ICHR(2)="40
	ILINE((K-1)*5+2)=ICHR(1)
	ILINE((K-1)*5+4)=ICHR(2)
	GOTO 80
C	  CONVERT THIS DATA TO COORDINATE INFO
 45	CONTINUE
	LLL=IBUF(J+K)
	LLLL=LLL.AND."1777
	IF((LLL.AND."20000).NE.0) LLLL=0-LLLL
	ENCODE(5,46,ILINE((K-1)*5+1)) LLLL
C	CALL IDIGIT(ICHAR,ILINE((K-1)*5+1))
 46	FORMAT(I5)
	GOTO 80
C	WE FOUND AN INSTRUCTION - PLACE INTO BUFFER
 50	OINSTR=L
	DO 60 M=1,5
	ILINE((K-1)*5+M)=VTINST((L-1)*5+M)
 60	CONTINUE
C
 80	CONTINUE
	WRITE(5,90) (ILINE(K),K=1,40)
 90	FORMAT(7X,8(3X,5A1)/)
 10	FORMAT(1X,O6,8(2X,O6))
 100	CONTINUE
	STOP
C
C	COMES HERE IF HE WISHES TO PLOT THE DISPLAY FILE
C
 110	CONTINUE
C	INITIALIZE PLOTTER - TURN ON
	DO 112 I=1,3
 111	J=IOUTT1(PLTON(I))
	IF(J.NE.0) GOTO 111
 112	CONTINUE
C
C	RESET PLOTTER
	DO 114 I=1,3
113	J=IOUTT1(PLTRST(I))
	IF(J.NE.0) GOTO 113
114	CONTINUE
C	INITIALIZE FLAGS
	IFLAG=0
	MODE=0
	DINSTR=0
	OINSTR=0
	INTENS=0
	I=ISTART
	NEW=1
120	CONTINUE
	IF(IBUF(I).LT.0) GOTO 900
125	IF(DINSTR.NE.0) GOTO 129
	WRITE(5,126) IBUF(I),I
126	FORMAT(' ERROR in decoding display file:',O6,' at ',O6)
	STOP
C	FIGURE WHICH INSTRUCTION IT IS
129	WRITE(5,131) I
131	FORMAT(' Address=',O6)
	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),DINSTR
C	DHALT - IGNORE THIS DATA WORD
130	IF(IBUF(I).EQ.0) IFLAG=IFLAG+1
	IF(IBUF(I).NE.0) IFLAG=0
	IF(IFLAG.GE.2) STOP
	NEW=0
	I=I+1
	GOTO 1000
C
C	DJSR - WE DON'T HAVE THIS INSTRUCTION
C
150	STOP'Missing DJSR support'
C
C	DJMPA - NOT YET SUPPORTED
C
200	CALL PRINT('DJMPA not supported')
	NEW=0
	OINSTR=0
C
C	DNOP WAS PREVIOUS INSTRUCTION; INTERPRET UNDER OLD INSTRUCTION
C
250	NEW=0
	IF(OINSTR.EQ.0) GOTO 260
	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),OINSTR
260	I=I+1
	GOTO 1000
C
C	LOAD STATUS REG A - SAME ACTION AS PREVIOUS INSTRUCTION=DNOP
300	GOTO 250
C
C	LOAD STATUS REGISTER B - SAME AS ABOVE
350	GOTO 250
C
C	XGRA - EVERY WORD IS A DATA POINT
400	NEW=0
	IY=IBUF(I)
	I=I+1
	GOTO 1000
C
C	YGRA - SAME AS XGRA EXCEPT ROTATED 90 DEGREES
450	NEW=0
	IX=IBUF(I)
	I=I+1
	GOTO 1000
C
C	NOW FOR THE IMPORTANT STUFF - LVECT
C
500	NEW=0
	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
	I=I+1
C	NOW PLOT THIS VECTOR
C	SEE IF THIS IS THE FIRST LVECT
	IF(MODE.NE.0) GOTO 510
C	IF SO, SEND A GS TO PUT US IN VECTOR DRAWING STATE
	CALL OUTT(GS)
C	SEE IF WE SHOULD ACTUALLY DRAW THIS VECTOR RATHER THAN JUST MOVE
	IF((IX.AND."040000).NE.0) CALL OUTT(BELL)
	MODE=1
	GOTO 520
C
C	SEE IF WE SHOULD HAVE PEN DOWN OR NOT
510	IF((IX.AND."040000).EQ.0) CALL OUTT(GS)
520	CONTINUE
C	COMPUTE COORDINATES
	ITX=IX.AND."001777
	ITY=IY.AND."001777
	IF((IX.AND."020000).NE.0) ITX=0-ITX
	IF((IY.AND."020000).NE.0) ITY=0-ITY
	CALL PLOT(ITX,ITY)
	GOTO 1000
C
C	SVECT
C
550	NEW=0
	CALL OUTT(GS)
C	SEE IF THE PEN SHOULD BE DOWN
	IF((IBUF(I).AND."040000).NE.0) CALL OUTT(BELL)
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	CALL PLOT(IX,IY)
	I=I+1
	GOTO 1000
C
C	TEXT
C
C	FIRST RESET THE PLOTTER
600	IF(NEW.EQ.-1) GOTO 630
	NEW=-1
C	SET POSITION OF PEN 2 POINTS ABOVE STARTING LOCATION
C	SO IT LOOKS JUST LIKE THE SCREEN
	CALL OUTT(GS)
	CALL PLOT(0,2)
C	NOW RESET THE PLOTTER TO GET INTO ASCII MODE
	DO 610 J=1,3
610	CALL OUTT(PLTRST(J))
C	NOW SET UP THE PROPER SCALING
	DO 620 J=1,9
620	CALL OUTT(TSCAL(J))
C	NOW SEND THE CHARACTERS
630	K=IBUF(I).AND."177
	K1=IBUF(I)/256
	CALL OUTT(K)
	CALL OUTT(K1)
	J=0
	IF(K.NE.0) J=1
	IF(K1.NE.0) J=J+1
	I=I+1
	IWORD=0
C	INCREASE X-POSITION SO IF WE DRAW ANY VECTORS WE WILL THINK
C	THAT WE ARE IN CORRECT LOCATION
	LASTX=LASTX+TWIDTH*J
	GOTO 1000
C
C	APNT
C
650	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
	I=I+1
	ITX=(IX.AND."1777)
	ITY=(IY.AND."1777)
	MODE=0
	IF((IX.AND."040000).NE.0) MODE=1
	CALL APLOT(ITX,ITY,MODE)
	GOTO 1000
C
C	RPNT
C
700	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	CALL OUTT(GS)
	CALL PLOT(IX,IY)
C	SEE IF WE SHOULD MAKE A DOT HERE
	IF((IBUF(I).AND."040000).NE.0) GOTO 720
	CALL OUTT(BELL)
	CALL PLOT(0,0)
720	I=I+1
	GOTO 1000
C
C	COMES HERE IF WE GOT AN INSTRUCTION
900	CONTINUE
C	CHECK IF PREVIOUS INSTRUCTION WAS 'TEXT'
C	IF SO, THEN REPOSITION PEN 2 POINTS DOWN
	IF(NEW.NE.-1) GOTO 905
	CALL OUTT(GS)
	CALL PLOT(0,-2)
905	CONTINUE
	DO 910 J=1,13
	IVAL=IBUF(I)
	IF(J.GE.5) IVAL=IVAL.AND."174000
	IF(IVAL.EQ.INSTR(J)) GOTO 920
910	CONTINUE
915	FORMAT(' Erroneous instruction found:',O6)
	WRITE(5,915) IBUF(I)
	STOP
920	OINSTR=DINSTR
	DINSTR=J
C	PICK UP INTENSITY FROM SET GRAPHIC MODE INSTRUCTION
	IF((IVAL.AND."002000).NE.0.AND.J.GE.5)
     C		INTENS=(IBUF(I).AND."001600)/"200
	I=I+1
	MODE=0
	NEW=1
C
C	PAD THE OUTPUT SO WE DON'T GET AN OVERRUN
1000	CONTINUE

	DO 1100 J=1,5
1100	CALL OUTT(PLTPAD)
	IF(I.LE.IEND) GOTO 120
	STOP
	END


	SUBROUTINE PLOT(IX,IY)
	COMMON/PLOTTR/LASTX,LASTY
	LASTX=(LASTX+IX)
	LASTY=(LASTY+IY)
	LASTXX=LASTX
	LASTYY=LASTY
	IF(LASTX.GT."1777) LASTXX="1777
	IF(LASTY.GT."1777) LASTYY="1777
	IF(LASTX.LT.0) LASTXX=0
	IF(LASTY.LT.0) LASTYY=0
C	SCALE Y DIMENSION PROPERLY SO IT WILL FIT ON PLOTTER
C	TRIED 3124., BUT DIDN'T SEEM TO WORK PROPERLY
	LASTYY=FLOAT(LASTYY)*(2731./4096.)
C	FIRST CHAR OUTPUT = HIY
	ICHAR="040+(LASTYY/"40)
	CALL OUTT(ICHAR)
C	XLOY - IGNORE
	CALL OUTT("177)
C	LOY
	ICHAR="140+(LASTYY.AND."37)
	CALL OUTT(ICHAR)
C	NOW FOR X - HIX
	ICHAR="040+(LASTXX/"40)
	CALL OUTT(ICHAR)
C	LOX
	ICHAR="100+(LASTXX.AND."37)
	CALL OUTT(ICHAR)
	RETURN
	END



	SUBROUTINE APLOT(IX,IY,INTENS)
	COMMON/PLOTTR/LASTX,LASTY
	INTEGER GS,BELL
	DATA GS/"35/,BELL/"7/
C	SET UP NEW LASTX AND LASTY
	LASTX=IX.AND."1777
	LASTY=IY.AND."1777
C	GET INTO GRAPHIC MODE WITHOUT (BELL) TO DRAW AN INVISIBLE LINE
	CALL OUTT(GS)
C	NOW LET PLOT DO ALL THE WORK
	CALL PLOT(0,0)
C	SEE IF WE SHOULD DROP THE PEN AND MAKE A DOT
	IF(INTENS.EQ.0) CALL OUTT(GS)
	CALL PLOT(0,0)
	RETURN
	END


	SUBROUTINE OUTT(ICHAR)
1	J=IOUTT1(ICHAR)
	IF(J.NE.0) GOTO 1
	RETURN
	END



	SUBROUTINE RSTR(FNAME)
	LOGICAL*1 FNAME(30)
	COMMON/DFILE/IBUF(32)
C
	DO 50 I=10000,1,-1
	IBUF(I)=-1
50	CONTINUE
C
	CALL ASSIGN(1,FNAME)
	DEFINE FILE 1(64,256,U,IBLK)
C	OPEN(UNIT=1,NAME=FNAME,READONLY,TYPE='OLD',ACCESS='DIRECT',
C     C		ASSOCIATEVARIABLE=IBLK,RECORDSIZE=128)
	IBLK=1
	READ(1'IBLK,END=110)J,(IBUF(K),K=1,255)
	IPTR=J
	DO 100 J=1,IPTR,256
	K0=J+255
	K9=J+510
100	READ(1'IBLK,END=110)(IBUF(K),K=K0,K9)
	CALL CLOSE(1)
	RETURN
C	  COMES HERE IF WE GET AN END OF FILE
 110	WRITE(5,120)
 120	FORMAT(' ***Encountered premature End of File***')
C	CLOSE(UNIT=1)
	CALL CLOSE(1)
	RETURN
	END
 