C	  REMOTE LINE HANDLING SUBROUTINES
C	  FEATURES INTERRUPT HANDLING OF THE INPUT FROM THE REMOTE
C	  DEVICE
C	    WRITTEN BY MICHAEL LAMPI  SPRING 1979
C
	FUNCTION IOUTT1(INPUT)
C	  OUTPUT FUNCTION
C	   CALLING THIS SUBROUTINE WITH INPUT SET TO -1 CAUSES A 'BREAK'
C	   CONDITION TO BE SET. CALLING AGAIN WITH ANY NORMAL CHARACTER
C	   RESETS THE 'BREAK' AND SENDS THAT CHARACTER.
C	   CALLING THIS SUBROUTINE WITH INPUT SET TO -2 CAUSES THE
C	   INTERRUPT-DRIVEN SUBROUTINE TO BECOME DISABLED--INTERRUPT
C	   IS TURNED OFF
C	   CALLING THIS SUBROUTINE WITH INPUT SET TO -3 RESETS INTERRUPT
C	   ON AND ENABLES THE INPUT SUBROUTINE
C
C	IDLBFO IS ADDRESS OF OUTPUT DL11-W BUFFER
C	IDLCSR IS STATUS REGISTER ADDRESS
C	IDLCSI IS THE STATUS REGISTER OF THE INPUT BUFFER
	DATA IDLBFO/"176506/
	DATA IDLCSR/"176504/
	DATA IDLSET/"000000/
	DATA IDLCSI/"176500/
	DATA JOUT/2*0/
	DATA ITST/0/
C
C	SEE IF THIS IS FIRST TIME THROUGH
	IF(ITST.EQ.1) GOTO 5
	ITST=1
C
C	INITIALIZE REGISTER
	CALL IPOKE(IDLCSR,IDLSET)
C
C	CHECK IF USER WANTS A 'BREAK' SENT TO THE DEVICE
C	  OR IF HE WANTS TO TURN OFF THE INTERRUPT (& QUIT)
 5	IF(INPUT.GE.0) GOTO 10
	IF(INPUT.NE.-1) GOTO 7
C	YES - SET DEVICE REGISTER BIT 0 - BREAK
	CALL IPOKE(IDLCSR,1)
	IOUTT1=0
	ITST=0
	RETURN
C
C	  HE WANTS TO TURN OFF/ON INTERRUPT
 7	IF(INPUT.EQ.-2) CALL IPOKE(IDLCSI,0)
	IF(INPUT.EQ.-3) CALL IPOKE(IDLCSI,"100)
	IOUTT1=0
	RETURN
C
C	CHECK IF OUTPUT(PRINTER) IS READY FOR ANOTHER CHARACTER
 10	J=IPEEK(IDLCSR).AND."200
	IF(J.NE.0) GOTO 15
C	NOT READY - RETURN 1 STATUS
	IOUTT1=1
	RETURN
C
C	OUTPUT DEVICE(PRINTER) IS READY FOR A CHARACTER - SHIP IT
15	CALL IPOKE(IDLBFO,INPUT)
	IOUTT1=0
	RETURN
	END






	FUNCTION INPTT1(IDUMMY)
C	  VISIBLE HALF OF INTERRUPT-DRIVEN INPUT ROUTINES
C	  WRITTEN BY MICHAEL LAMPI  FALL 1978
C
C	NOW FOR THE INTERRUPT STUFF
	DIMENSION IDL11(4)
	COMMON /INPTT1/ INBUFF(100),IPTR,IEND
	LOGICAL*1 INBUFF
	EXTERNAL TTYIN1
	DATA ITST/0/,IPTR/1/,IEND/1/
	DATA IDL11/"176500,0,0,0/
C
C	IDLBFI IS ADDRESS OF INPUT BUFFER
C	IDLCSR IS ADDRESS OF STATUS REGISTER
	DATA IDLBFI/"176502/
	DATA IDLCSR/"176500/
C
	INPTT1=-1
	IF(ITST.NE.0) GOTO 10
C
C	SET UP INTERRUPT DRIVER
C
C	SET VECTOR TO BE SENT TO DEVICE WHEN WE END EXECUTION
	CALL DEVICE(IDL11)
C	SET UP THE INTERRUPT HANDLING ROUTINE
	IF(INTSET("300,7,1111,TTYIN1).NE.0)
     C		STOP'CANNOT SET INTERRUPT ENABLE FOR TT1'
	ITST=1
C	ENABLE RECEIVER INTERRUPT
	CALL IPOKE(IDLCSR,"100)
	RETURN
C
10	IF(IPTR.EQ.IEND) RETURN
	IF(IPTR.EQ.100) IPTR=0
	IPTR=IPTR+1
	I=INBUFF(IPTR)
C	  FIX PROBLEM WITH HI-ORDER BIT PROPAGATION
	INPTT1=I.AND."377
	RETURN
	END




	SUBROUTINE TTYIN1(J)
C	  INVISIBLE SUBROUTINE TO HANDLE THE REMOTE COMPUTER LINE
C	  INTERRUPTS
C	  WRITTEN BY MICHAEL LAMPI  FALL 1978
	COMMON/INPTT1/INBUFF(100),IPTR,IEND
	LOGICAL*1 INBUFF
	DATA IDLCSR/"176500/
	DATA IDLBFI/"176502/
C	  CHECK FOR ILLEGAL ENTRY
	IF(J.NE.1111) STOP'UNDEFINED INTERRUPT'
C	  CHECK FOR A FULL RING BUFFER
	IOEND=IEND
	IF(IEND.EQ.100) IEND=0
	IEND=IEND+1
	IF(IPTR.EQ.IEND) GOTO 999
C	  GET A CHARACTER
 10	I=IPEEK(IDLBFI)
	IF((I.AND."177400).EQ.0) GOTO 20
	IF((I.AND."040000).NE.0) CALL PRINT('OVERRUN ERR')
	IF((I.AND."010000).NE.0) CALL PRINT('PARITY ERR')
	IF((I.AND."020000).NE.0) CALL PRINT('FRAME ERR')
 20	INBUFF(IEND)=I.AND."377
C	  RESET INTERRUPT
	CALL IPOKE(IDLCSR,"100)
	RETURN
C
C	  ERROR MESSAGE FOR QUEUE OVERFLOW
C
 999	CALL PRINT('TT1 INPUT QUEUE OVERFLOW')
	GOTO 10
	END
