C	  THESE SUBROUTINES ARE DESIGNED TO EASE THE TASK OF ACCESSING
C	  THE AR11 BOARD A BIT EASIER THAN OTHERWISE POSSIBLE
C
C	  SUBROUTINES INCLUDED WILL ALLOW YOU TO ACCESS EACH OF THE 16
C	  A/D CHANNELS USING THE FUNCTION SUBROUTINE IATOD, ACCESS THE
C	  AR11 REAL-TIME CLOCK USING THE SUBROUTINE CLKSET AND THE
C	  FUNCTION ICLKRD DESIGNED TO READ THE CLOCK, AND SUBROUTINES
C	  DAC, DACX & DACY DESIGNED TO SET THE DACS TO PROPER LEVELS.
C
C	*************************************************************
C	**	NOTE:   IATOD, DAC, DACX, & DACY AHVE BEEN	   **
C	**		IMPLEMENTED IN MACRO-11 TO INCREASE	   **
C	**		EXECUTION SPEED				   **
C	*************************************************************
C
C	  WRITTEN BY MICHAEL LAMPI      APRIL 1979
C
C	  FUNCTION TO RETURN THE VALUE RETURNED BY A GIVEN A/D CHANNEL
C	FUNCTION IATOD(ICHAN,IRANGE)
C	IMPLICIT INTEGER (A-Z)
C	DATA ADCSR/"170400/,ADBUF/"170402/
CC
CC	  DETERMINE WHICH RANGE OF VOLTAGES IS TO BE USED:
CC	  IRANGE=0  -  -2.5 TO +2.5 VOLTS
CC	  IRANGE=1  -   0.0 TO +4.995 VOLTS
CC
C	RANGE="20001
C	IF(IRANGE.NE.0) RANGE=1
CC
CC	  CHECK WHICH CHANNEL IS TO BE READ
CC
C	CHAN=(ICHAN.AND."17) * "400
CC
CC	  START CONVERSION
CC
C	CALL IPOKE(ADCSR,CHAN+RANGE)
CC
CC	  WAIT FOR CONVERSION TO COMPLETE
CC
C 10	IF((IPEEK(ADCSR).AND.1).NE.0) GOTO 10
CC
CC	  GET VALUE
CC
C	IATOD=IPEEK(ADBUF)
C	RETURN
C	END
C

	SUBROUTINE CLKSET(IRATE,IMODE,ICNT)
C	  SUBROUTINE TO SET AND START THE AR11 REAL-TIME CLOCK
C	  5 INTERNAL RATES AVAILABLE:
C	    1  -  1 MHZ
C	    2  -  100 KHZ
C	    3  -  10 KHZ
C	    4  -  1 KHZ
C	    5  -  100 HZ
C	  2 MODES AVAILABLE:
C	    0  -  SINGLE INTERVAL AND STOP
C	    1  -  REPEATED INTERVALS (NO STOP)
C	  8 BITS OF COUNTER AVAILABLE FOR RANGING BETWEEN CLOCK RATES
C
C	  NOTE: THIS SUBROUTINE IS NOT INTERRUPT-DRIVEN EVEN THOUGH THE
C		REAL-TIME CLOCK ALLOWS THIS CAPABILITY
C
	IMPLICIT INTEGER (A-Z)
	DATA CLKCSR/"170404/,CLKBUF/"170406/
C
C	  SET THE MODE AND THE RATE AND THE COUNT
C
	MODE=(IMODE.AND.1) * "400
	RATE=(IRATE.AND.7) * 2 + 1
C	  COUNT MUST BE TWO'S COMPLEMENT OF DESIRED COUNT
	COUNT= -ICNT
C
C	  NOW INITIALIZE THE CLOCK COUNTER BUFFER
C
	CALL IPOKE(CLKBUF,COUNT)
C
C	  START THE CLOCK
C
	CALL IPOKE(CLKCSR,MODE+RATE)
	RETURN
	END





	FUNCTION ICLKRD(IRESET)
C	  THIS FUNCTION ENABLES READING OF THE AR11 REAL-TIME CLOCK
C	  AND RETURNS THE VALUE 0 IF THE CLOCK BUFFER HAS NOT OVERFLOWED
C	  AND RETURNS THE VALUE 1 IF OVERFLOW HAS OCCURRED.
C	  IRESET IS USED TO FLAG WHETHER THE USER WISHES TO RESET
C	  AND RESTART THE CLOCK IF OVERFLOW HAS OCCURRED.
C
	IMPLICIT INTEGER (A-Z)
	DATA CLKCSR/"170404/,CLKBUF/"170406/
C
C	  CHECK FOR OVERFLOW BIT ON
C
	IF((IPEEK(CLKCSR).AND."200).NE.0) GOTO 10
C
C	  NO OVERFLOW BIT ON YET - SIMPLY RETURN A ZERO
C
	ICLKRD=0
	RETURN
C
C	  CLOCK OVERFLOW BIT ON - CHECK IF WE SHOULD RESET CLOCK
C
 10	ICLKRD=1
	IF(IRESET.EQ.0) RETURN
C
C	  YES - RESET CLOCK
C	  FIRST RELOAD CLOCK COUNTER REGISTER BY READING PRESET/BUFFER
C	  REGISTER
C
	CALL IPOKE(CLKBUF,IPEEK(CLKBUF))
C
C	  RESTART CLOCK
C
	CALL IPOKE(CLKCSR,(IPEEK(CLKCSR).AND."177576)+1)
	RETURN
	END






C	SUBROUTINE DAC(IX,IY)
CC	  THIS SUBROUTINE ENABLES YOU TO WRITE 10 BITS OF INFORMATION
CC	  BOTH OF THE DACS ON THE AR11 BOARD.
CC
C	IMPLICIT INTEGER (A-Z)
C	DATA DACXBF/"170412/,DACYBF/"170414/
CC
CC	  DUMP DATA TO X-DAC, THEN Y-DAC
CC
C	CALL IPOKE(DACXBF,IX)
C	CALL IPOKE(DACYBF,IY)
C	RETURN
C	END
C
C	SUBROUTINE DACX(IX)
CC	  THIS SUBROUTINE DUMPS DATA TO THE X-DAC ONLY
C	IMPLICIT INTEGER (A-Z)
C	DATA DACXBF/"170412/
CC	  DUMP DATA TO THE X-DAC
C	CALL IPOKE(DACXBF,IX)
C	RETURN
C	END
C
C	SUBROUTINE DACY(IY)
CC	  THIS SUBROUTINE DUMPS DATA TO THE Y-DAC ONLY
C	IMPLICIT INTEGER(A-Z)
C	DATA DACYBF/"170414/
CC	  DUMP DATA TO THE Y-DAC
C	CALL IPOKE(DACYBF,IY)
C	RETURN
C	END
C


	SUBROUTINE JOYSTK (IX, IY, IHIT)
C
C	SUBROUTINE JOYSTK RETURNS THE X-Y POSITION
C	OF THE JOYSTICK, EACH RANGING FROM 0 TO 1023.
C	IHIT CONTAINS A 1 IF THE INTERRUPT BUTTON HAS
C	BEEN PRESSED SINCE THE LAST CALL, ELSE 0.
C
C  TECH NOTES:
C	THE AR-11 A/D CHANNEL ASSIGNMENTS ARE AS FOLLOWS
C		X: CHANNEL 1
C		Y: CHANNEL 0
C		SWITCH: CHANNEL 2
C
C	THE X AND Y VALUES FROM THE JOYSTICK ARE HIGH AT
C	THE BOTTOM AND LOW AT THE TOP (BACKWARDS); THIS
C	SWITCHES THEM AND SCALES THEM TO 0-1023.  THE NXLO,
C	NXHI, NYLO, AND NYHI VALUES ARE THE CORNER POINTS
C	OF A RECTANGLE ON THE JOYSTICK.  IF SOME VALUES
C	CANNOT BE REACHED WITH THE JOYSTICK, THESE CORNER
C	POINTS SHOULD BE CAREFULLY ADJUSTED TO GIVE EQUAL
C	RESOLUTION IN BOTH THE X- AND Y-DIRECTIONS.
C
C	WRITTEN BY R. B. BARTLEIN -- AUGUST 30, 1978.
C	MODIFIED BY MICHAEL LAMPI -- FALL 1978
C	TO PERFORM PARALLEL PROCESSING OF THE A/D INPUT AND TO
C	PERFORM FASTER PROCESSING OF THE A/D INFORMATION
C
	DATA KADST/"170400/, KADBUF/"170402/
	DATA KXSEL/"020401/, KYSEL/"020001/, KSWSEL/"021001/
	DATA NXLO/149/, NXHI/828/, NYLO/117/, NYHI/900/
	DATA LSWTCH/1022/, XRANGE/1.50663/, YRANGE/1.30651/, NHIT/0/
C	XRANGE=1023./(NXHI-NXLO)
C	YRANGE=1023./(NYHI-NYLO)
	DATA IFLAG/0/
C
C		GET X-VALUE
C
	CALL IPOKE(KADST,KXSEL)
 110	IF(IPEEK(KADST) .EQ. KXSEL) GOTO 110
	IX=IPEEK(KADBUF)
C	  START A/D CONVERSION WHILE COMPUTING X-VALUE
	CALL IPOKE(KADST,KYSEL)
C	     ... AND COMPUTE X-VALUE DURING THIS TIME
	IX=FLOAT(NXHI-IX)*XRANGE+0.5
	IX=MAX0(MIN0(IX,1023),0)
C
C		GET Y-VALUE
C
C	   WAIT FOR Y-CONVERSION TO COMPLETE
 120	IF(IPEEK(KADST) .EQ. KYSEL) GOTO 120
	IY=IPEEK(KADBUF)
C	  START A/D CONVERSION FOR BUTTON WHILE COMPUTING Y-VALUE
	CALL IPOKE(KADST,KSWSEL)
C	     ... AND FINISH COMPUTING Y-VALUE
	IY=FLOAT(NYHI-IY)*YRANGE+0.5
	IY=MAX0(MIN0(IY,1023),0)
C
C		GET SWITCH-STATUS
C
 130	IF(IPEEK(KADST) .EQ. KSWSEL) GOTO 130
	I=IPEEK(KADBUF)
C	  CHECK FOR THE A/D VALUE - ABOVE OR BELOW THRESHHOLD?
	IF (I .GT. LSWTCH) GOTO 140
C	  BELOW THRESHHOLD - SWITCH MUST HAVE BEEN RECENTLY DEPRESSED
C	  IF IFLAG IS 1 THEN WE HAVE ALREADY RECORDED THIS AS A HIT
	IF(IFLAG.EQ.1) GOTO 150
	IFLAG=1
	IHIT=1
	RETURN
C
C	  ABOVE THRESHHOLD - NO HIT
 140	IFLAG=0
C
C	  NO HIT
 150	IHIT=0
	RETURN
	END
