;  DEC/CMS REPLACEMENT HISTORY, Element INIVM.RSX
;  *3    18-AUG-1986 11:22:47 WORRALL "Complete HEX listing support for version 5.5 fieldtest"
;  *2    14-APR-1986 23:26:25 SYSTEM "Update 5.4 of MACRO-11"
;  *1    28-MAR-1986 02:38:40 SYSTEM "Load MACRO-11 sources from V5.3"
;  DEC/CMS REPLACEMENT HISTORY, Element INIVM.RSX
	.NLIST							;Edit Level 00
	.ENABL	LC,GBL
	.LIST
	.TITLE	INIVM - Custom virtual memory routines for MACRO-11
	.SBTTL	INIVM - Custom virtual memory routines for MACRO-11
	.SBTTL
	.SBTTL		.IDENT	/V05.05/
	.SBTTL
	.IDENT	/V05.05/
;****************************************************************************
;*									    *
;*                   COPYRIGHT (c)  1983, 1986                              *
;*          BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.                *
;*                   ALL RIGHTS RESERVED.                                   *
;* 									    *
;*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  *
;*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  *
;*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  *
;*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  *
;*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *
;*  TRANSFERRED.							    *
;* 									    *
;*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  *
;*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *
;*  CORPORATION.							    *
;* 									    *
;*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  *
;*  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.		    *
;*									    *
;****************************************************************************


;++
;  Facility:	MACRO-11  The PDP-11 macro assembler for RT/RSX/VMS and RSTS/E
;
;    Author:	Too many people to list here
;
;   Created:	From the dust and dirt
;
;  Abstract:	INIVM - Custom virtual memory routines for MACRO-11
;
;     Externals	 Description
;     ---------	 -----------
;
;      Edit	Who	Date		Description of modification
;      ----	---	----		---------------------------
;--


	W$$KST	= 0	;Add work file statistics

;+
; $INIVM - INITIALIZE VIRTUAL MEMORY WORK FILE SYSTEM
;
; THIS ROUTINE INITIALIZES THE VIRTUAL MEMORY WORK FILE SUB-
; SYSTEM.  TO DO THIS IT FORCES ALL PAGES TO BE NON-RESIDENT,
; ALLOCATES THE FIRST PAGE, OPENS THE WORK FILE, AND MARKS
; IT FOR DELETION WHEN CLOSED.
;
; INPUTS:
;	R1=TOP TASK VIRTUAL ADDRESS
;	$WRKPT CONTAINS ADDRESS OF WORK FILE FDB
;	$FRHD  CONTAINS ADDRESS OF DYNAMIC MEMORY POOL
;
; OUTPUTS:
;	C-BIT CLEAR  AND/OR  R0=0 INDICATES SUCCESS
;
;	-OR-
;
;	C-BIT SET INDICATES FAILURE  AND/OR
;	      R0=-2 INDICATES WORK FILE OPEN FAILURE
;	      R0=-1 INDICATES WORK FILE MARK FOR DELETE FAILURE
;-
 
;
; MACRO LIBRARY CALLS
;
 
	.MCALL	FCSBT$
	FCSBT$	DEF$L
	.MCALL	FDOFF$
	FDOFF$	DEF$L
	.MCALL	OFNB$
 
	.IF	DF	T$$MP
 
	.MCALL	NMBLK$
 
	PURE	DPURE,D

WRKNM:	NMBLK$	WRKFIL,TMP
 
	.ENDC

	PURE	PUREI,I
 
$INIVM::SAVRG			;++035 SAVE THE NON-VOLATILE REGISTERS
 
	.IF DF	W$$KST
	MOV	R1,$TPADR	; SET TOP ADDRESS IN TASK
	MOV	#$WRKAC,R0	; GET ADDRESS OF WORK FILE ACCESS COUNTS
.REPT	6
	CLR	(R0)+		; CLEAR ACCESS COUNTS
.ENDR
	.ENDC
 
	MOV	#1,$HGVAD	;SET FIRST FREE ADDR NONZERO IN PAGE 0
	MOV	#400,$HGPAG	;SET FIRST INTEGRAL PAGE AVAILABLE
	CLR	$PAGHD		;SET NO RESIDENT PAGES
	CLR	$PAGLS		; CLEAR POINTER TO RESIDENT PAGE LIST
	CLR	$TIME		; RESET PAGE TIME
	MOV	#$FRHD,R0	; GET ADDRESS OF FREE POOL LISTHEAD
	MOV	(R0)+,R1	; GET ADDRESS OF CORE POOL
	CLR	(R0)		; SECOND WORD OF LIST MUST BE ZERO
	CMP	2(R1),#<N$MPAG*P$GSIZ> ; ENOUGH ROOM FOR FAST PAGE SEARCH
	BLO	5$		; IF LO NO
	MOV	#512.,R1	; SET SIZE OF RESIDENT PAGE LIST
	CALL	$ALBLK		; ALLOCATE RESIDENT PAGE LIST
	MOV	R0,$PAGLS	; SAVE ADDRESS OF LIST

5$:	MOV	#P$GSIZ,R1	;PUT PAGE SIZE IN R1
	CALL	$ALBLK		;ALLOCATE FIRST PAGE
	MOV	R0,$PAGHD	;LINK IT TO RESIDENT PAGE LIST HEAD
	MOV	$PAGLS,R1	;++035 GET ADDRESS OF RESIDENT PAGE LIST
	BEQ	7$		;++035 IF EQ NONE
	MOV	R0,(R1)		;++035 SET THIS PAGE RESIDENT
7$:
;
; OPEN WORK FILE
;
	MOV	$WRKPT,R0	;POINT R0 TO WORK FILE FDB

;	.WEAK	W$BSIZ
	MOV	#W$BSIZ,F.ALOC(R0) ;Set initial workfile size (GBLDEF)

;;;	MOV	#-2,-(SP)	;ASSUME FILE OPEN FAILURE (STS=-2)
 
	.IF	DF	T$$MP
 
	MOV	R0,R1		;++035 COPY FDB ADDRESS
	ADD	#F.FNB,R1	;++035 POINT TO FILENAME BLOCK
	CLR	R2		;++035 NO DATASET DESCRIPTOR
	MOV	#WRKNM,R3	;++035 SET ADDRESS OF DEFAULT FILENAME BLOCK
	CALL	.PARSE		;++035 ENTER TEMP. FILE NAME IN DIRECTORY
	BCS	10$		;++035 IF C/S PARSE FAILED
;;;	INC	(SP)		;++035 SPECIFY SUCCESFUL PARSE
20$:	OFNB$	R0,#<FO.WRT>	;++035 OPEN FILE FOR WRITE
	BCS	30$		;++035 IF C/S OPEN FAILURE

	.IFF
 
20$:	OFNB$	R0,#<FA.TMP!FO.WRT> ;CREATE TEMPORARY WORK FILE
	BCS	30$		;BRANCH IF ERROR
;;;	INC	(SP)		;ASSUME MARK FOR DELETE FAILURE (STS=-1)
	CALL	.MRKDL		;MARK FILE FOR DELETE AFTER CLOSE
	BCS	10$		;BRANCH IF ERROR
 
	.ENDC
 
;;;	INC	(SP)		;SPECIFY SUCCESSFUL INIT (STS=0)
	CALL	HSHINI		;INITIALIZE SYMBOL TABLES
;;;	CLC
;;;	MOV	(SP)+,R0	;Return status in R0
	RETURN			;Return to caller - really back to root!

;	?MACRO-F-Workfile I/O error.

10$:	CLR	R2		;Set dummy parameter block address	;??
	MOV	#<S$V2*400!E$R73>,R1 ; Get error/severity (Workfile I/O err)
	CALL	$ERMSG		;Fatal ... No return

; Possible contiguous space problem
; open the workfile non-contiguous.

30$:	TST	F.ALOC(R0)	;Positive value here?
	BMI	10$		;Branch if not, already tryed non-contig.
	NEG	F.ALOC(R0)	;Set non-contiguous open
	BR	20$		;and go try open again.

;
; ALLOCATE CONTIGUOUS PAGES TO HASH TABLES AND ZERO THEM
;

;	N$SYPG==24.		;NUMBER OF USER PRIMARY HASH TABLE PAGES
;	.IF DF	XCIS
;	N$PSPG==4.		;NUMBER OF PST PRIMARY PAGES
;	.IFF
;	N$PSPG==5.		;ALLOCATE EXTRA PAGE IF CIS ENABLED
;	.ENDC			;(XCIS)

HSHINI:	MOV	$HGPAG,$HPSBS	;SET BASE ADDR OF PST/MACRO HASH TABLE
	MOV	#N$PSPG,-(SP)	;SET NUMBER OF PRIMARY PAGES IN ALLOCATION
456$:	CALL	$ALPAG		;GET A PAGE AND ZERO IT
	DEC	(SP)
	BNE	456$		;REPEAT FOR PROPER NUMBER OF BLOCKS
	MOV	#N$PSPG*400,$HPSLM ;SET PAGE LIMIT IN HIGH BYTE
	CLR	$HPOFL		;CLEAR PST OVERLFLOW PAGE POINTER

	MOV	#N$SYPG,(SP)	;SET NUMBER OF PAGES TO ALLOCATE IN USER TABLE
	MOV	$HGPAG,$HSYBS	;SET BASE ADDR OF HASH TABLE
123$:	CALL	$ALPAG		;ALLOCATE A BLOCK AND ZERO IT
	DEC	(SP)
	BNE	123$
	MOV	#N$SYPG*400,$HSYLM ;SET PRIMARY PAGE LIMIT IN HIGH BYTE
	CLR	$HSOFL		;CLEAR USER OVERLFLOW PAGE POINTER
	TST	(SP)+		;JUNK THE COUNTER

	CALL	$ALPAG		;NOW ALLOCATE PAGE FOR FIRST LOCAL SYMBOL BUF
	MOV	R1,LSYBAS	;SAVE THE ADDRESS FOR SEARCH ROUTINE
	RETURN


	.END
