$!******************************************************************************
$!
$! TKBBLD.COM - command file to build the RSX TKB libraries.
$!
$!******************************************************************************
$!
$!
$ _ON ERROR THEN GOTO EXIT
$ _SET ECHO
$ _SET JOB/PRIORITY=-16
$!
$ _ASSIGN/USER/REPLACE D:         BL
$ _ASSIGN/USER/REPLACE D:$        LIB
$ _ASSIGN/USER/REPLACE D:[170,0]  CMN
$ _ASSIGN/USER/REPLACE D:[170,90] RMS
$!
$! Set up logicals to point to local (test) account
$!
$ _ASSIGN/USER/REPLACE D:[170,53] RSX
$ _ASSIGN/USER/REPLACE D:[170,60] FCS
$ _ASSIGN/USER/REPLACE D:[170,61] UTL
$ _ASSIGN/USER/REPLACE D:[170,62] MAC
$ _ASSIGN/USER/REPLACE D:[170,63] LBR
$ _ASSIGN/USER/REPLACE D:[170,64] TKB
$ _ASSIGN/USER/REPLACE D:[170,65] RNO
$ _ASSIGN/USER/REPLACE D:[170,66] PAT
$ _ASSIGN/USER/REPLACE D:[170,67] CRF
$!
$ _ASSIGN/USER/REPLACE D:[170,64] SYSTEM
$ _ASSIGN/USER/REPLACE D:[170,64] LST
$ _ASSIGN/USER/REPLACE D:[170,53] LB
$!
$ _SET PROT/DEFAULT 60
$!
$! Delete old versions
$!
$ _DELETE/NOLOG/NOWARN  SYSTEM:*.BAK
$ _DELETE/NOLOG/NOWARN  SYSTEM:*.OBJ
$ _DELETE/NOLOG/NOWARN  SYSTEM:*.LST
$!
$! Set protections
$!
$ _SET FILE/PROT=40 SYSTEM:HDRDF.MAC
$ _SET FILE/PROT=40 SYSTEM:LBLDF.MAC
$ _SET FILE/PROT=40 SYSTEM:SEGDF.MAC
$ _SET FILE/PROT=40 SYSTEM:PLSDF.MAC
$ _SET FILE/PROT=40 SYSTEM:MACFLM.MAC
$!
$RUN LIB:MAC
@TKB:TKBASM
@TKB:VMUTLA
$EOD
$!
$RUN LIB:CRF
@TKB:TKBCRF
@TKB:VMUCRF
$EOD
$!
$RUN LIB:LBR
@TKB:TKBLIB
@TKB:VMULIB
SYSTEM:VMLIB.VLB=TKB:VMLIB.OLB/EX
$EOD
$!
$RUN LIB:PIP
SYSTEM:TKB.OLB<40>/RE
SYSTEM:VMLIB.OBJ<40>=SYSTEM:VMLIB.VLB/RE/SI:-1
SYSTEM:VMLIB.OLB<40>/RE
TKB:VMLIB.OLB<40>/RE
$EOD
$!
$RUN LIB:TKB
@TKB:HFTID
$!
$RUN LIB:TKB
@TKB:TKBBLD
$!
$RUN LIB:STK
@TKB:STKBLD
$!
$RUN LIB:TKB
@TKB:TKBID
@TKB:STKID
$!
$RUN LIB:CRF
SYSTEM:TKB.MAP
SYSTEM:STK.MAP
SYSTEM:TKBID.MAP
SYSTEM:STKID.MAP
SYSTEM:HFT.MAP
$EOD
$!
$RUN LIB:MAKSIL
TKB/DEBUG
SYSTEM:TKB.TSK
YES
SYSTEM:TKB.STB
SYSTEM:TKB.SIL
$EOD
$!
$RUN LIB:MAKSIL
STK/DEBUG
SYSTEM:STK.TSK
YES
SYSTEM:STK.STB
SYSTEM:STK.SIL
$EOD
$!
$ _DELETE/NOLOG/NOWARN  SYSTEM:TKB.TSK
$ _DELETE/NOLOG/NOWARN  SYSTEM:TKB.STB
$ _RENAME/NOLOG 	SYSTEM:TKB.SIL SYSTEM:TKB.TSK
$!
$ _DELETE/NOLOG/NOWARN  SYSTEM:STK.TSK
$ _DELETE/NOLOG/NOWARN  SYSTEM:STK.STB
$ _RENAME/NOLOG 	SYSTEM:STK.SIL SYSTEM:STK.TSK
$!
$ _DELETE/NOLOG/NOWARN  SYSTEM:TKBID.STB
$ _DELETE/NOLOG/NOWARN  SYSTEM:STKID.STB
$!
$ _DELETE/NOLOG/NOWARN  SYSTEM:HFT.STB
$!
$EXIT:
$ _IF $SEVERITY .EQ. 1 THEN _WRITE 0 "TKBBLD completed successfully"
$ _IF $SEVERITY .NE. 1 THEN _WRITE 0 "TKBBLD completed with errors"
$!
$ _SET JOB/PRIORITY=-8
$ _exit

