/*
 *	SEND SOCKET TCP
 */

#define	UNIX	0
#define	OS2	1

#include	   <stdio.h>
#include    <errno.h>
#include	   <sys/socket.h>
#include	   <netinet/in.h>
#include	   <netdb.h>
#include    <sock_err.h>

#if	OS2
#include	   <sockdefs.h>
#endif

#if	UNIX
#define	MAX_SOCKETS	32

typedef	unsigned long	Fd_set;
#define	FD_ZERO(l)	(*(l) = 0L)
#define	FD_SET(s, l)	(*(l) |= (1L << s))
#define	FD_CLR(s, l)	(*(l) &= ~(1L << s))
#define	FD_ISSET(s, l)	(*(l) & (1L << s))
#define	RM_OFFSET(s)	(s)
#define	ADD_OFFSET(s)	(s)

#define	socket_perror(a)	perror(a)
#define	socket_read(a, b, c)	read(a, b, c)
#define	socket_write(a, b, c)	write(a, b, c)
#define	socket_close(a)		close(a)
#endif

#if	OS2
typedef	fd_set		Fd_set;
#endif

typedef	unsigned char	uchar_t;

char     buf[128];

extern   int   errno;

unsigned long		taddr_n, taddr_h;
short			tport_n, tport_h;

main(argc, argv)
int  argc;
char      *argv[];
{
	int			s, ns;
	int			rc;
	int			addrlen;
	struct sockaddr		addr;
	struct sockaddr_in	sa_in;
	int			i;
	struct	hostent		*he;

	getline(buf, "Host name : ");
	he = gethostbyname(buf);
	memcpy((char *) &taddr_n, he->h_addr, he->h_length);
	taddr_h = ntohl(taddr_n);
	getline(buf, "Enter port : ");
	tport_h = atoi(buf);
	tport_n = htons(tport_h);

	s = socket(AF_INET, SOCK_STREAM, 6);
	printf("RM_OFFSET(%d)=%d\n", s, RM_OFFSET(s));
	if (s == -1)
	{
		printf("socket() failed, errno=%d\n", errno);
		perror("");
		exit(1);
	}
	sa_in.sin_family      = AF_INET;
	sa_in.sin_port        = tport_n;
	sa_in.sin_addr.s_addr = taddr_n;
	showAddr("target address", &sa_in);

	printf("Before connect ...\n");
	rc = connect(s, (struct sockaddr *) &sa_in, sizeof(sa_in));
	printf("After connect rc=%d\n", rc);
	if (rc == -1)
	{
		printf("connect() failed, errno=%d\n", errno);
      close_socket(s);
		exit(0);
	}

	for (;;)
	{
		int	len;

		getline(buf, "sending a new msg - type 'q' to quit : ");
		if (buf[0] == 'q')
			break;
		getline(buf, "Enter msg : ");
		len = strlen(buf);
      if(send(s, buf, len, 0) != len)
		{
			printf("write error\n");
			break;
		}
		printf("\n=================================\n");
	}
   close_socket(s);
}

getline(line, prompt)
char   *line;
char         *prompt;
{
	char	ch;

	printf("%s", prompt);
	while ((ch = getchar()) != '\n' && ch != EOF)
		*line++ = ch;
	*line = '\0';
	if (ch == EOF)
		return(EOF);
}

showAddr(str, a)
char    *str;
struct	sockaddr_in	*a;
{
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b1);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b2);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b3);
	printf("%03d!", (uchar_t) a->sin_addr.S_un.S_un_b.s_b4);
	printf("%u \n", (unsigned short) a->sin_port);
}

