/*
 *	RCV SOCKET UDP
 */

#define	UNIX	0
#define	OS2	1

#include	<stdio.h>
#include <errno.h>
#include	<ctype.h>
#include	<signal.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include <sock_err.h>

#if	OS2
#include	<sockdefs.h>
#endif

typedef	unsigned char	uchar_t;

#if	UNIX
#define	MAX_SOCKETS	32

typedef	unsigned long	Fd_set;
#define	FD_ZERO(l)	(*(l) = 0L)
#define	FD_SET(s, l)	(*(l) |= (1L << s))
#define	FD_CLR(s, l)	(*(l) &= ~(1L << s))
#define	FD_ISSET(s, l)	(*(l) & (1L << s))
#define	RM_OFFSET(s)	(s)
#define	ADD_OFFSET(s)	(s)

#define	socket_perror(a)	perror(a)
#define	socket_read(a, b, c)	read(a, b, c)
#define	socket_write(a, b, c)	write(a, b, c)
#define	socket_close(a)		close(a)
#endif

#if	OS2
typedef	fd_set		Fd_set;
#endif

char		buf[128];
extern   int   	errno;

int		snmp_skt = -1;
Fd_set		skt_list;

main(argc, argv)
int  argc;
char      *argv[];
{
	int			s;
	short			rc;
	struct sockaddr_in	sa_in, from;
	short			port;
	int			shut_down_rcvr();

	signal(SIGINT, shut_down_rcvr);
	getline(buf, "Enter port : ");
	port = atoi(buf);

	sa_in.sin_family      = AF_INET;
	sa_in.sin_port        = htons(port);
	sa_in.sin_addr.s_addr = INADDR_ANY;

	errno = 0;
	s = socket(AF_INET, SOCK_DGRAM, 17);
	printf("s=%d\n", s);
	if (s == -1)
	{
		printf("socket() failed, errno=%d\n", errno);
		perror("");
		exit(1);
	}
	errno = 0;
	rc = bind(s, (struct sockaddr *) &sa_in, sizeof(sa_in));
	if (rc == -1)
	{
		printf("bind() failed, errno=%d\n", errno);
		perror("");
      close_socket(s);
		exit(1);
	}

	snmp_skt = s;
	FD_SET(s, &skt_list);

	for (;;)
	{
		int	n;
		int	flags = 0;
		int	fromlen;
		Fd_set	ready;

		memcpy((char *) &ready, (char *) &skt_list, sizeof(fd_set));
		printMask(1, "before select", &ready);
		rc = select(MAX_SOCKETS,
			    &ready,
			    (fd_set *) 0,
			    (fd_set *) 0,
			    (struct timeval *) 0);
		printMask(1, "after  select", &ready);
		if (!FD_ISSET(snmp_skt, &ready))
			continue;
		fromlen = sizeof(struct sockaddr_in);
		n = recvfrom(snmp_skt,
			     buf,
			     127,
			     flags,
			     (struct sockaddr *) &from,
			     &fromlen);
		showAddr("rcvd from", &from);
		if (n < 1)
		{
			printf("recvfrom returned %d\n", n);
			hit_return();
			continue;
		}
		buf[n] = '\0';
		printf("MSG=");
		printf("[%s]\n", buf);
		if (strcmp(buf, "stop") == 0)
			shut_down_rcvr();
	}
}

showAddr(str, a)
char    *str;
struct	sockaddr_in	*a;
{
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b1);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b2);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b3);
	printf("%03d!", (uchar_t) a->sin_addr.S_un.S_un_b.s_b4);
	printf("%u \n", (unsigned short) a->sin_port);
}

printMask(flag, str, m)
int	flag;
char	*str;
Fd_set   *m;
{
	int   i;

	if (flag < 1)
		return;
	printf("%-20s : mask[", str);
	for (i = 0; i < MAX_SOCKETS; i++)
	{
		if (i % 8 == 0)
			putchar(' ');
		if (FD_ISSET(i, m))
			putchar('1');
		else
			putchar('0');
	}
	printf(" ]\n");
}

shut_down_rcvr()
{
	int	s;

	printf("Closing socket [ ");
	printf("%d ", snmp_skt);
   close_socket(snmp_skt);
	getline(buf, "], hit return : ");
	exit(0);
}

hit_return()
{
	char	tbuf[32];

	getline(tbuf, "hit return : ");
}

getline(line, prompt)
char   *line;
char         *prompt;
{
	char	ch;

	printf("%s", prompt);
	while ((ch = getchar()) != '\n' && ch != EOF)
		*line++ = ch;
	*line = '\0';
	if (ch == EOF)
		return(EOF);
}

